/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.yubico.core.RegistrationStorage;
import com.yubico.core.SessionManager;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.device.MultifactorAuthenticationDeviceManager;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.trusted.web.flow.BasicMultifactorTrustedWebflowConfigurer;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.actions.DefaultMultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.authentication.FinalMultifactorAuthenticationTransactionWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.webauthn.web.flow.WebAuthnAccountCheckRegistrationAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnAccountSaveRegistrationAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnAuthenticationWebflowAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnMultifactorWebflowConfigurer;
import org.apereo.cas.webauthn.web.flow.WebAuthnPopulateCsrfTokenAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnStartAuthenticationAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnStartRegistrationAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnValidateSessionCredentialTokenAction;
import org.apereo.cas.webauthn.web.flow.account.WebAuthnMultifactorAccountProfilePrepareAction;
import org.apereo.cas.webauthn.web.flow.account.WebAuthnMultifactorAccountProfileRegistrationAction;
import org.apereo.cas.webauthn.web.flow.account.WebAuthnMultifactorAccountProfileWebflowConfigurer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.WebAuthn})
@Configuration(value="WebAuthnWebflowConfiguration", proxyBeanMethods=false)
class WebAuthnWebflowConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 100;
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.mfa.web-authn.core.enabled").isTrue().evenIfMissing();

    WebAuthnWebflowConfiguration() {
    }

    @Configuration(value="WebAuthnAccountProfileWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AccountManagement}, enabledByDefault=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    static class WebAuthnAccountProfileWebflowConfiguration {
        WebAuthnAccountProfileWebflowConfiguration() {
        }

        @ConditionalOnMissingBean(name={"webAuthnAccountProfileWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer webAuthnAccountProfileWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new WebAuthnMultifactorAccountProfileWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties)).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"webAuthnAccountCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer webAuthnAccountCasWebflowExecutionPlanConfigurer(@Qualifier(value="webAuthnAccountProfileWebflowConfigurer") CasWebflowConfigurer webAuthnAccountProfileWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(webAuthnAccountProfileWebflowConfigurer);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"webAuthnDeviceProviderAction"})
        public MultifactorAuthenticationDeviceProviderAction webAuthnDeviceProviderAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="webAuthnMultifactorAuthenticationDeviceManager") MultifactorAuthenticationDeviceManager webAuthnMultifactorAuthenticationDeviceManager) {
            return (MultifactorAuthenticationDeviceProviderAction)BeanSupplier.of(MultifactorAuthenticationDeviceProviderAction.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DefaultMultifactorAuthenticationDeviceProviderAction(webAuthnMultifactorAuthenticationDeviceManager)).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"webAuthnAccountProfilePrepareAction"})
        public Action webAuthnAccountProfilePrepareAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="webAuthnMultifactorAuthenticationProvider") MultifactorAuthenticationProvider webAuthnMultifactorAuthenticationProvider, CasConfigurationProperties casProperties, @Qualifier(value="webAuthnCredentialRepository") RegistrationStorage webAuthnCredentialRepository) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new WebAuthnMultifactorAccountProfilePrepareAction(webAuthnCredentialRepository, webAuthnMultifactorAuthenticationProvider, casProperties)).withId("webAuthnAccountProfilePrepareAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"webAuthnAccountProfileRegistrationAction"})
        public Action webAuthnAccountProfileRegistrationAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="webAuthnMultifactorAuthenticationProvider") MultifactorAuthenticationProvider webAuthnMultifactorAuthenticationProvider) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new WebAuthnMultifactorAccountProfileRegistrationAction(webAuthnMultifactorAuthenticationProvider)).withId("webAuthnAccountProfileRegistrationAction").build().get();
        }
    }

    @Configuration(value="WebAuthnWebflowActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class WebAuthnWebflowActionConfiguration {
        WebAuthnWebflowActionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"webAuthnPopulateCsrfTokenAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnPopulateCsrfTokenAction(@Qualifier(value="webAuthnCsrfTokenRepository") CsrfTokenRepository webAuthnCsrfTokenRepository, ConfigurableApplicationContext applicationContext) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new WebAuthnPopulateCsrfTokenAction(webAuthnCsrfTokenRepository)).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @ConditionalOnMissingBean(name={"webAuthnStartAuthenticationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnStartAuthenticationAction(CasConfigurationProperties casProperties, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, ConfigurableApplicationContext applicationContext, @Qualifier(value="webAuthnCredentialRepository") RegistrationStorage webAuthnCredentialRepository) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new WebAuthnStartAuthenticationAction(casProperties, ticketRegistry, ticketFactory, webAuthnCredentialRepository, tenantExtractor)).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @ConditionalOnMissingBean(name={"webAuthnStartRegistrationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnStartRegistrationAction(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new WebAuthnStartRegistrationAction(casProperties, tenantExtractor)).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @ConditionalOnMissingBean(name={"webAuthnCheckAccountRegistrationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnCheckAccountRegistrationAction(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, ConfigurableApplicationContext applicationContext, @Qualifier(value="webAuthnCredentialRepository") RegistrationStorage webAuthnCredentialRepository) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new WebAuthnAccountCheckRegistrationAction(webAuthnCredentialRepository, tenantExtractor)).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @ConditionalOnMissingBean(name={"webAuthnSaveAccountRegistrationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnSaveAccountRegistrationAction(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, ConfigurableApplicationContext applicationContext, @Qualifier(value="webAuthnSessionManager") SessionManager webAuthnSessionManager, @Qualifier(value="webAuthnCredentialRepository") RegistrationStorage webAuthnCredentialRepository) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new WebAuthnAccountSaveRegistrationAction(webAuthnCredentialRepository, webAuthnSessionManager, tenantExtractor)).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @ConditionalOnMissingBean(name={"webAuthnAuthenticationWebflowAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnAuthenticationWebflowAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="webAuthnAuthenticationWebflowEventResolver") CasWebflowEventResolver webAuthnAuthenticationWebflowEventResolver) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new WebAuthnAuthenticationWebflowAction(webAuthnAuthenticationWebflowEventResolver)).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @ConditionalOnMissingBean(name={"webAuthnValidateSessionCredentialTokenAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnValidateSessionCredentialTokenAction(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, ConfigurableApplicationContext applicationContext, @Qualifier(value="webAuthnSessionManager") SessionManager webAuthnSessionManager, @Qualifier(value="webAuthnPrincipalFactory") PrincipalFactory webAuthnPrincipalFactory, @Qualifier(value="webAuthnCredentialRepository") RegistrationStorage webAuthnCredentialRepository) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new WebAuthnValidateSessionCredentialTokenAction(webAuthnCredentialRepository, webAuthnSessionManager, webAuthnPrincipalFactory, tenantExtractor)).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }
    }

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthenticationTrustedDevices}, module="webauthn")
    @Configuration(value="WebAuthnMultifactorTrustConfiguration", proxyBeanMethods=false)
    @DependsOn(value={"webAuthnMultifactorWebflowConfigurer"})
    static class WebAuthnMultifactorTrustConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.mfa.web-authn.trusted-device-enabled").isTrue().evenIfMissing();

        WebAuthnMultifactorTrustConfiguration() {
        }

        @ConditionalOnMissingBean(name={"webAuthnMultifactorTrustWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer webAuthnMultifactorTrustWebflowConfigurer(@Qualifier(value="webAuthnFlowRegistry") FlowDefinitionRegistry webAuthnFlowRegistry, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).and(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                BasicMultifactorTrustedWebflowConfigurer cfg = new BasicMultifactorTrustedWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, webAuthnFlowRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
                cfg.setOrder(101);
                return cfg;
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer webAuthnMultifactorTrustCasWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="webAuthnMultifactorTrustWebflowConfigurer") CasWebflowConfigurer webAuthnMultifactorTrustWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).and(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(webAuthnMultifactorTrustWebflowConfigurer)).otherwiseProxy().get();
        }
    }

    @Configuration(value="WebAuthnWebflowExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class WebAuthnWebflowExecutionPlanConfiguration {
        WebAuthnWebflowExecutionPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"webAuthnCasWebflowExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer webAuthnCasWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="webAuthnMultifactorWebflowConfigurer") CasWebflowConfigurer webAuthnMultifactorWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(webAuthnMultifactorWebflowConfigurer)).otherwiseProxy().get();
        }
    }

    @Configuration(value="WebAuthnWebflowEventResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class WebAuthnWebflowEventResolutionConfiguration {
        WebAuthnWebflowEventResolutionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"webAuthnAuthenticationWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver webAuthnAuthenticationWebflowEventResolver(ConfigurableApplicationContext applicationContext, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return (CasWebflowEventResolver)BeanSupplier.of(CasWebflowEventResolver.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new FinalMultifactorAuthenticationTransactionWebflowEventResolver(casWebflowConfigurationContext)).otherwiseProxy().get();
        }
    }

    @Configuration(value="WebAuthnWebflowBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class WebAuthnWebflowBaseConfiguration {
        WebAuthnWebflowBaseConfiguration() {
        }

        @ConditionalOnMissingBean(name={"webAuthnMultifactorWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer webAuthnMultifactorWebflowConfigurer(@Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="webAuthnFlowRegistry") FlowDefinitionRegistry webAuthnFlowRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                WebAuthnMultifactorWebflowConfigurer cfg = new WebAuthnMultifactorWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, webAuthnFlowRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
                cfg.setOrder(100);
                return cfg;
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="WebAuthnWebflowRegistryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class WebAuthnWebflowRegistryConfiguration {
        WebAuthnWebflowRegistryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"webAuthnFlowRegistry"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FlowDefinitionRegistry webAuthnFlowRegistry(@Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="flowBuilder") FlowBuilder flowBuilder, ConfigurableApplicationContext applicationContext) {
            return (FlowDefinitionRegistry)BeanSupplier.of(FlowDefinitionRegistry.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)applicationContext, flowBuilderServices);
                builder.addFlowBuilder(flowBuilder, "mfa-webauthn");
                return builder.build();
            }).otherwiseProxy().get();
        }
    }
}

