/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.session;

import java.io.Serializable;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.session.MapSession;
import org.springframework.session.MapSessionRepository;

public class TicketRegistrySessionRepository
extends MapSessionRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketRegistrySessionRepository.class);
    private final TicketRegistry ticketRegistry;
    private final TicketFactory ticketFactory;

    public TicketRegistrySessionRepository(TicketRegistry ticketRegistry, TicketFactory ticketFactory) {
        super(new ConcurrentHashMap());
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
    }

    public void save(MapSession session) {
        FunctionUtils.doUnchecked(__ -> {
            if (!session.getId().equals(session.getOriginalId())) {
                this.deleteById(session.getOriginalId());
            }
            String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)session.getId());
            try {
                TransientSessionTicket currentTicket = (TransientSessionTicket)this.ticketRegistry.getTicket(ticketId, TransientSessionTicket.class);
                currentTicket.getProperties().putAll(TicketRegistrySessionRepository.convertSessionAttributes(session));
                LOGGER.trace("Updating session [{}] with properties [{}]", (Object)currentTicket.getId(), (Object)currentTicket);
                this.ticketRegistry.updateTicket((Ticket)currentTicket);
            }
            catch (InvalidTicketException e) {
                TransientSessionTicketFactory factory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
                Map<String, Object> properties = TicketRegistrySessionRepository.convertSessionAttributes(session);
                TransientSessionTicket ticket = factory.create(ticketId, properties);
                LOGGER.trace("Saving session [{}] with properties [{}]", (Object)ticket.getId(), (Object)ticket);
                this.ticketRegistry.addTicket((Ticket)ticket);
            }
        }, (Object[])new Object[0]);
    }

    public MapSession findById(String id) {
        try {
            String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)id);
            LOGGER.trace("Finding session by id [{}]", (Object)ticketId);
            TransientSessionTicket ticket = (TransientSessionTicket)this.ticketRegistry.getTicket(ticketId, TransientSessionTicket.class);
            MapSession newSession = new MapSession(ticket.getId());
            newSession.setCreationTime((Instant)ticket.getProperty("creationTime", Instant.class));
            newSession.setLastAccessedTime((Instant)ticket.getProperty("lastAccessedTime", Instant.class));
            Map sessionAttributes = (Map)ticket.getProperty("attributes", Map.class);
            sessionAttributes.forEach((key, value) -> {
                byte[] decoded = EncodingUtils.decodeBase64((String)value.toString());
                Serializable attributeValue = (Serializable)SerializationUtils.deserialize((byte[])decoded, Serializable.class);
                newSession.setAttribute(key.toString(), (Object)attributeValue);
            });
            LOGGER.trace("Found session [{}] with attributes [{}]", (Object)newSession.getId(), (Object)sessionAttributes);
            return newSession;
        }
        catch (InvalidTicketException e) {
            LOGGER.trace("Session with id [{}] not found", (Object)id, (Object)e);
            return null;
        }
    }

    public void deleteById(String id) {
        FunctionUtils.doUnchecked(__ -> {
            LOGGER.trace("Deleting session by id [{}]", (Object)id);
            this.ticketRegistry.deleteTicket(id);
        }, (Object[])new Object[0]);
    }

    private static Map<String, Object> convertSessionAttributes(MapSession session) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("lastAccessedTime", session.getLastAccessedTime());
        properties.put("creationTime", session.getCreationTime());
        properties.put("originalId", session.getOriginalId());
        properties.put("id", session.getId());
        Map<String, String> sessionAttributes = session.getAttributeNames().stream().map(name -> {
            Serializable value = (Serializable)session.getAttribute(name);
            return value == null ? null : Pair.of((Object)name, (Object)SerializationUtils.serializeBase64((Serializable)value));
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        properties.put("attributes", sessionAttributes);
        return properties;
    }
}

