/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.services.BaseRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class CerbosRegisteredServiceAccessStrategy
extends BaseRegisteredServiceAccessStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CerbosRegisteredServiceAccessStrategy.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private static final long serialVersionUID = -2218211604445278440L;
    @ExpressionLanguageCapable
    private String apiUrl;
    @ExpressionLanguageCapable
    private String token;
    @ExpressionLanguageCapable
    private String scope;
    @ExpressionLanguageCapable
    private String rolesAttribute = "memberOf";
    @ExpressionLanguageCapable
    private String kind;
    @ExpressionLanguageCapable
    private String requestId;
    private List<String> actions;
    private Map<String, Object> auxData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorizeRequest(RegisteredServiceAccessStrategyRequest request) {
        HttpResponse response = null;
        try {
            HashMap attributes = new HashMap(request.getAttributes());
            attributes.put("serviceUrl", List.of(request.getService().getId()));
            attributes.put("serviceName", List.of(request.getRegisteredService().getName()));
            attributes.put("serviceId", List.of(Long.valueOf(request.getRegisteredService().getId())));
            attributes.put("serviceFriendlyName", List.of(request.getRegisteredService().getFriendlyName()));
            attributes.put("serviceType", List.of(request.getRegisteredService().getClass().getSimpleName()));
            List<String> roles = attributes.getOrDefault(this.rolesAttribute, List.of()).stream().map(Object::toString).toList();
            Object cerbosRequest = ((CerbosRequest.CerbosRequestBuilder)((CerbosRequest.CerbosRequestBuilder)((CerbosRequest.CerbosRequestBuilder)((CerbosRequest.CerbosRequestBuilder)CerbosRequest.builder().requestId(SpringExpressionLanguageValueResolver.getInstance().resolve(this.requestId))).principal((CerbosPrincipal)((CerbosPrincipal.CerbosPrincipalBuilder)((CerbosPrincipal.CerbosPrincipalBuilder)((CerbosPrincipal.CerbosPrincipalBuilder)((CerbosPrincipal.CerbosPrincipalBuilder)CerbosPrincipal.builder().id(request.getPrincipalId())).scope(this.scope)).roles(roles)).attr(attributes)).build())).resources(List.of(((CerbosResources.CerbosResourcesBuilder)((CerbosResources.CerbosResourcesBuilder)CerbosResources.builder().resource((CerbosResource)((CerbosResource.CerbosResourceBuilder)((CerbosResource.CerbosResourceBuilder)((CerbosResource.CerbosResourceBuilder)((CerbosResource.CerbosResourceBuilder)CerbosResource.builder().id(String.valueOf(request.getRegisteredService().getId()))).kind(this.kind)).scope(this.scope)).attr(attributes)).build())).actions(this.actions.toArray(ArrayUtils.EMPTY_STRING_ARRAY))).build()))).auxData(this.auxData)).build();
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("Content-Type", "application/json");
            if (StringUtils.isNotBlank((CharSequence)this.token)) {
                headers.put("Authorization", "Bearer " + SpringExpressionLanguageValueResolver.getInstance().resolve(this.token));
            }
            String givenUrl = (String)StringUtils.defaultIfBlank((CharSequence)SpringExpressionLanguageValueResolver.getInstance().resolve(this.apiUrl), (CharSequence)"http://localhost:3592");
            String url = Strings.CI.removeEnd(givenUrl, (CharSequence)"/") + "/api/check/resources";
            HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.POST).url(url).headers(headers).entity(((CerbosRequest)cerbosRequest).toJson()).build();
            LOGGER.debug("Submitting authorization request to [{}] for [{}]", (Object)url, cerbosRequest);
            response = HttpUtils.execute((HttpExecutionRequest)exec);
            try (InputStream content = ((HttpEntityContainer)response).getEntity().getContent();){
                String results = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
                LOGGER.trace("Received response from endpoint [{}] as [{}]", (Object)url, (Object)results);
                CerboseResponse payload = (CerboseResponse)MAPPER.readValue(results, CerboseResponse.class);
                if (HttpStatus.resolve((int)response.getCode()).is2xxSuccessful() && Strings.CI.equals(((CerbosRequest)cerbosRequest).getRequestId(), payload.getRequestId())) {
                    boolean bl = payload.getResults().isEmpty() || payload.getResults().stream().allMatch(result -> this.actions.stream().allMatch(action -> {
                        Actions actionResult = result.getActions().get(action);
                        return actionResult != Actions.EFFECT_DENY;
                    }));
                    HttpUtils.close((HttpResponse)response);
                    return bl;
                }
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return false;
    }

    @Override
    @Generated
    public String toString() {
        return "CerbosRegisteredServiceAccessStrategy(super=" + super.toString() + ", apiUrl=" + this.apiUrl + ", token=" + this.token + ", scope=" + this.scope + ", rolesAttribute=" + this.rolesAttribute + ", kind=" + this.kind + ", requestId=" + this.requestId + ", actions=" + String.valueOf(this.actions) + ", auxData=" + String.valueOf(this.auxData) + ")";
    }

    @Generated
    public String getApiUrl() {
        return this.apiUrl;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public String getScope() {
        return this.scope;
    }

    @Generated
    public String getRolesAttribute() {
        return this.rolesAttribute;
    }

    @Generated
    public String getKind() {
        return this.kind;
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public List<String> getActions() {
        return this.actions;
    }

    @Generated
    public Map<String, Object> getAuxData() {
        return this.auxData;
    }

    @Generated
    public CerbosRegisteredServiceAccessStrategy setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return this;
    }

    @Generated
    public CerbosRegisteredServiceAccessStrategy setToken(String token) {
        this.token = token;
        return this;
    }

    @Generated
    public CerbosRegisteredServiceAccessStrategy setScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Generated
    public CerbosRegisteredServiceAccessStrategy setRolesAttribute(String rolesAttribute) {
        this.rolesAttribute = rolesAttribute;
        return this;
    }

    @Generated
    public CerbosRegisteredServiceAccessStrategy setKind(String kind) {
        this.kind = kind;
        return this;
    }

    @Generated
    public CerbosRegisteredServiceAccessStrategy setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Generated
    public CerbosRegisteredServiceAccessStrategy setActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    @Generated
    public CerbosRegisteredServiceAccessStrategy setAuxData(Map<String, Object> auxData) {
        this.auxData = auxData;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CerbosRegisteredServiceAccessStrategy)) {
            return false;
        }
        CerbosRegisteredServiceAccessStrategy other = (CerbosRegisteredServiceAccessStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$apiUrl = this.apiUrl;
        String other$apiUrl = other.apiUrl;
        if (this$apiUrl == null ? other$apiUrl != null : !this$apiUrl.equals(other$apiUrl)) {
            return false;
        }
        String this$token = this.token;
        String other$token = other.token;
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$scope = this.scope;
        String other$scope = other.scope;
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$rolesAttribute = this.rolesAttribute;
        String other$rolesAttribute = other.rolesAttribute;
        if (this$rolesAttribute == null ? other$rolesAttribute != null : !this$rolesAttribute.equals(other$rolesAttribute)) {
            return false;
        }
        String this$kind = this.kind;
        String other$kind = other.kind;
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        String this$requestId = this.requestId;
        String other$requestId = other.requestId;
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        List<String> this$actions = this.actions;
        List<String> other$actions = other.actions;
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        Map<String, Object> this$auxData = this.auxData;
        Map<String, Object> other$auxData = other.auxData;
        return !(this$auxData == null ? other$auxData != null : !((Object)this$auxData).equals(other$auxData));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CerbosRegisteredServiceAccessStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $apiUrl = this.apiUrl;
        result = result * 59 + ($apiUrl == null ? 43 : $apiUrl.hashCode());
        String $token = this.token;
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $scope = this.scope;
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $rolesAttribute = this.rolesAttribute;
        result = result * 59 + ($rolesAttribute == null ? 43 : $rolesAttribute.hashCode());
        String $kind = this.kind;
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        String $requestId = this.requestId;
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        List<String> $actions = this.actions;
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        Map<String, Object> $auxData = this.auxData;
        result = result * 59 + ($auxData == null ? 43 : ((Object)$auxData).hashCode());
        return result;
    }

    @Generated
    public CerbosRegisteredServiceAccessStrategy() {
    }

    private static final class CerbosRequest {
        private final String requestId;
        private final CerbosPrincipal principal;
        private final List<CerbosResources> resources;
        private final Map<String, Object> auxData;
        private final boolean includeMeta;

        @JsonIgnore
        String toJson() {
            return (String)FunctionUtils.doUnchecked(() -> MAPPER.writeValueAsString((Object)this));
        }

        @Generated
        private static boolean $default$includeMeta() {
            return true;
        }

        @Generated
        protected CerbosRequest(CerbosRequestBuilder<?, ?> b) {
            this.requestId = b.requestId;
            this.principal = b.principal;
            this.resources = b.resources;
            this.auxData = b.auxData;
            this.includeMeta = b.includeMeta$set ? b.includeMeta$value : CerbosRequest.$default$includeMeta();
        }

        @Generated
        public static CerbosRequestBuilder<?, ?> builder() {
            return new CerbosRequestBuilderImpl();
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public CerbosPrincipal getPrincipal() {
            return this.principal;
        }

        @Generated
        public List<CerbosResources> getResources() {
            return this.resources;
        }

        @Generated
        public Map<String, Object> getAuxData() {
            return this.auxData;
        }

        @Generated
        public boolean isIncludeMeta() {
            return this.includeMeta;
        }

        @Generated
        public static abstract class CerbosRequestBuilder<C extends CerbosRequest, B extends CerbosRequestBuilder<C, B>> {
            @Generated
            private String requestId;
            @Generated
            private CerbosPrincipal principal;
            @Generated
            private List<CerbosResources> resources;
            @Generated
            private Map<String, Object> auxData;
            @Generated
            private boolean includeMeta$set;
            @Generated
            private boolean includeMeta$value;

            @Generated
            public B requestId(String requestId) {
                this.requestId = requestId;
                return this.self();
            }

            @Generated
            public B principal(CerbosPrincipal principal) {
                this.principal = principal;
                return this.self();
            }

            @Generated
            public B resources(List<CerbosResources> resources) {
                this.resources = resources;
                return this.self();
            }

            @Generated
            public B auxData(Map<String, Object> auxData) {
                this.auxData = auxData;
                return this.self();
            }

            @Generated
            public B includeMeta(boolean includeMeta) {
                this.includeMeta$value = includeMeta;
                this.includeMeta$set = true;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "CerbosRegisteredServiceAccessStrategy.CerbosRequest.CerbosRequestBuilder(requestId=" + this.requestId + ", principal=" + String.valueOf(this.principal) + ", resources=" + String.valueOf(this.resources) + ", auxData=" + String.valueOf(this.auxData) + ", includeMeta$value=" + this.includeMeta$value + ")";
            }
        }

        @Generated
        private static final class CerbosRequestBuilderImpl
        extends CerbosRequestBuilder<CerbosRequest, CerbosRequestBuilderImpl> {
            @Generated
            private CerbosRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected CerbosRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CerbosRequest build() {
                return new CerbosRequest(this);
            }
        }
    }

    private static final class CerbosPrincipal {
        private String id;
        private String policyVersion;
        private String scope;
        private List<String> roles;
        private Map<String, ?> attr;

        @Generated
        protected CerbosPrincipal(CerbosPrincipalBuilder<?, ?> b) {
            this.id = b.id;
            this.policyVersion = b.policyVersion;
            this.scope = b.scope;
            this.roles = b.roles;
            this.attr = b.attr;
        }

        @Generated
        public static CerbosPrincipalBuilder<?, ?> builder() {
            return new CerbosPrincipalBuilderImpl();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getPolicyVersion() {
            return this.policyVersion;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @Generated
        public List<String> getRoles() {
            return this.roles;
        }

        @Generated
        public Map<String, ?> getAttr() {
            return this.attr;
        }

        @Generated
        public CerbosPrincipal setId(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public CerbosPrincipal setPolicyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
            return this;
        }

        @Generated
        public CerbosPrincipal setScope(String scope) {
            this.scope = scope;
            return this;
        }

        @Generated
        public CerbosPrincipal setRoles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        @Generated
        public CerbosPrincipal setAttr(Map<String, ?> attr) {
            this.attr = attr;
            return this;
        }

        @Generated
        public CerbosPrincipal(String id, String policyVersion, String scope, List<String> roles, Map<String, ?> attr) {
            this.id = id;
            this.policyVersion = policyVersion;
            this.scope = scope;
            this.roles = roles;
            this.attr = attr;
        }

        @Generated
        public CerbosPrincipal() {
        }

        @Generated
        public String toString() {
            return "CerbosRegisteredServiceAccessStrategy.CerbosPrincipal(id=" + this.id + ", policyVersion=" + this.policyVersion + ", scope=" + this.scope + ", roles=" + String.valueOf(this.roles) + ", attr=" + String.valueOf(this.attr) + ")";
        }

        @Generated
        public static abstract class CerbosPrincipalBuilder<C extends CerbosPrincipal, B extends CerbosPrincipalBuilder<C, B>> {
            @Generated
            private String id;
            @Generated
            private String policyVersion;
            @Generated
            private String scope;
            @Generated
            private List<String> roles;
            @Generated
            private Map<String, ?> attr;

            @Generated
            public B id(String id) {
                this.id = id;
                return this.self();
            }

            @Generated
            public B policyVersion(String policyVersion) {
                this.policyVersion = policyVersion;
                return this.self();
            }

            @Generated
            public B scope(String scope) {
                this.scope = scope;
                return this.self();
            }

            @Generated
            public B roles(List<String> roles) {
                this.roles = roles;
                return this.self();
            }

            @Generated
            public B attr(Map<String, ?> attr) {
                this.attr = attr;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "CerbosRegisteredServiceAccessStrategy.CerbosPrincipal.CerbosPrincipalBuilder(id=" + this.id + ", policyVersion=" + this.policyVersion + ", scope=" + this.scope + ", roles=" + String.valueOf(this.roles) + ", attr=" + String.valueOf(this.attr) + ")";
            }
        }

        @Generated
        private static final class CerbosPrincipalBuilderImpl
        extends CerbosPrincipalBuilder<CerbosPrincipal, CerbosPrincipalBuilderImpl> {
            @Generated
            private CerbosPrincipalBuilderImpl() {
            }

            @Override
            @Generated
            protected CerbosPrincipalBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CerbosPrincipal build() {
                return new CerbosPrincipal(this);
            }
        }
    }

    private static final class CerbosResources {
        private CerbosResource resource;
        private String[] actions;

        @Generated
        protected CerbosResources(CerbosResourcesBuilder<?, ?> b) {
            this.resource = b.resource;
            this.actions = b.actions;
        }

        @Generated
        public static CerbosResourcesBuilder<?, ?> builder() {
            return new CerbosResourcesBuilderImpl();
        }

        @Generated
        public CerbosResource getResource() {
            return this.resource;
        }

        @Generated
        public String[] getActions() {
            return this.actions;
        }

        @Generated
        public CerbosResources setResource(CerbosResource resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public CerbosResources setActions(String[] actions) {
            this.actions = actions;
            return this;
        }

        @Generated
        public CerbosResources(CerbosResource resource, String[] actions) {
            this.resource = resource;
            this.actions = actions;
        }

        @Generated
        public CerbosResources() {
        }

        @Generated
        public String toString() {
            return "CerbosRegisteredServiceAccessStrategy.CerbosResources(resource=" + String.valueOf(this.resource) + ", actions=" + Arrays.deepToString(this.actions) + ")";
        }

        @Generated
        public static abstract class CerbosResourcesBuilder<C extends CerbosResources, B extends CerbosResourcesBuilder<C, B>> {
            @Generated
            private CerbosResource resource;
            @Generated
            private String[] actions;

            @Generated
            public B resource(CerbosResource resource) {
                this.resource = resource;
                return this.self();
            }

            @Generated
            public B actions(String[] actions) {
                this.actions = actions;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "CerbosRegisteredServiceAccessStrategy.CerbosResources.CerbosResourcesBuilder(resource=" + String.valueOf(this.resource) + ", actions=" + Arrays.deepToString(this.actions) + ")";
            }
        }

        @Generated
        private static final class CerbosResourcesBuilderImpl
        extends CerbosResourcesBuilder<CerbosResources, CerbosResourcesBuilderImpl> {
            @Generated
            private CerbosResourcesBuilderImpl() {
            }

            @Override
            @Generated
            protected CerbosResourcesBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CerbosResources build() {
                return new CerbosResources(this);
            }
        }
    }

    private static final class CerbosResource {
        private String kind;
        private String id;
        private String policyVersion;
        private String scope;
        private Map<String, ?> attr;

        @Generated
        protected CerbosResource(CerbosResourceBuilder<?, ?> b) {
            this.kind = b.kind;
            this.id = b.id;
            this.policyVersion = b.policyVersion;
            this.scope = b.scope;
            this.attr = b.attr;
        }

        @Generated
        public static CerbosResourceBuilder<?, ?> builder() {
            return new CerbosResourceBuilderImpl();
        }

        @Generated
        public String getKind() {
            return this.kind;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getPolicyVersion() {
            return this.policyVersion;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @Generated
        public Map<String, ?> getAttr() {
            return this.attr;
        }

        @Generated
        public CerbosResource setKind(String kind) {
            this.kind = kind;
            return this;
        }

        @Generated
        public CerbosResource setId(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public CerbosResource setPolicyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
            return this;
        }

        @Generated
        public CerbosResource setScope(String scope) {
            this.scope = scope;
            return this;
        }

        @Generated
        public CerbosResource setAttr(Map<String, ?> attr) {
            this.attr = attr;
            return this;
        }

        @Generated
        public CerbosResource(String kind, String id, String policyVersion, String scope, Map<String, ?> attr) {
            this.kind = kind;
            this.id = id;
            this.policyVersion = policyVersion;
            this.scope = scope;
            this.attr = attr;
        }

        @Generated
        public CerbosResource() {
        }

        @Generated
        public String toString() {
            return "CerbosRegisteredServiceAccessStrategy.CerbosResource(kind=" + this.kind + ", id=" + this.id + ", policyVersion=" + this.policyVersion + ", scope=" + this.scope + ", attr=" + String.valueOf(this.attr) + ")";
        }

        @Generated
        public static abstract class CerbosResourceBuilder<C extends CerbosResource, B extends CerbosResourceBuilder<C, B>> {
            @Generated
            private String kind;
            @Generated
            private String id;
            @Generated
            private String policyVersion;
            @Generated
            private String scope;
            @Generated
            private Map<String, ?> attr;

            @Generated
            public B kind(String kind) {
                this.kind = kind;
                return this.self();
            }

            @Generated
            public B id(String id) {
                this.id = id;
                return this.self();
            }

            @Generated
            public B policyVersion(String policyVersion) {
                this.policyVersion = policyVersion;
                return this.self();
            }

            @Generated
            public B scope(String scope) {
                this.scope = scope;
                return this.self();
            }

            @Generated
            public B attr(Map<String, ?> attr) {
                this.attr = attr;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "CerbosRegisteredServiceAccessStrategy.CerbosResource.CerbosResourceBuilder(kind=" + this.kind + ", id=" + this.id + ", policyVersion=" + this.policyVersion + ", scope=" + this.scope + ", attr=" + String.valueOf(this.attr) + ")";
            }
        }

        @Generated
        private static final class CerbosResourceBuilderImpl
        extends CerbosResourceBuilder<CerbosResource, CerbosResourceBuilderImpl> {
            @Generated
            private CerbosResourceBuilderImpl() {
            }

            @Override
            @Generated
            protected CerbosResourceBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CerbosResource build() {
                return new CerbosResource(this);
            }
        }
    }

    private static final class CerboseResponse {
        private String requestId;
        private List<CerbosResult> results;
        private String cerbosCallId;

        @Generated
        protected CerboseResponse(CerboseResponseBuilder<?, ?> b) {
            this.requestId = b.requestId;
            this.results = b.results;
            this.cerbosCallId = b.cerbosCallId;
        }

        @Generated
        public static CerboseResponseBuilder<?, ?> builder() {
            return new CerboseResponseBuilderImpl();
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public List<CerbosResult> getResults() {
            return this.results;
        }

        @Generated
        public String getCerbosCallId() {
            return this.cerbosCallId;
        }

        @Generated
        public CerboseResponse setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Generated
        public CerboseResponse setResults(List<CerbosResult> results) {
            this.results = results;
            return this;
        }

        @Generated
        public CerboseResponse setCerbosCallId(String cerbosCallId) {
            this.cerbosCallId = cerbosCallId;
            return this;
        }

        @Generated
        public CerboseResponse(String requestId, List<CerbosResult> results, String cerbosCallId) {
            this.requestId = requestId;
            this.results = results;
            this.cerbosCallId = cerbosCallId;
        }

        @Generated
        public CerboseResponse() {
        }

        @Generated
        public String toString() {
            return "CerbosRegisteredServiceAccessStrategy.CerboseResponse(requestId=" + this.requestId + ", results=" + String.valueOf(this.results) + ", cerbosCallId=" + this.cerbosCallId + ")";
        }

        @Generated
        public static abstract class CerboseResponseBuilder<C extends CerboseResponse, B extends CerboseResponseBuilder<C, B>> {
            @Generated
            private String requestId;
            @Generated
            private List<CerbosResult> results;
            @Generated
            private String cerbosCallId;

            @Generated
            public B requestId(String requestId) {
                this.requestId = requestId;
                return this.self();
            }

            @Generated
            public B results(List<CerbosResult> results) {
                this.results = results;
                return this.self();
            }

            @Generated
            public B cerbosCallId(String cerbosCallId) {
                this.cerbosCallId = cerbosCallId;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "CerbosRegisteredServiceAccessStrategy.CerboseResponse.CerboseResponseBuilder(requestId=" + this.requestId + ", results=" + String.valueOf(this.results) + ", cerbosCallId=" + this.cerbosCallId + ")";
            }
        }

        @Generated
        private static final class CerboseResponseBuilderImpl
        extends CerboseResponseBuilder<CerboseResponse, CerboseResponseBuilderImpl> {
            @Generated
            private CerboseResponseBuilderImpl() {
            }

            @Override
            @Generated
            protected CerboseResponseBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CerboseResponse build() {
                return new CerboseResponse(this);
            }
        }
    }

    private static final class CerbosResult {
        private CerbosResource resource;
        private Map<String, Actions> actions;
        private Map<String, Actions> validationErrors;
        private Map<String, Object> meta;

        @Generated
        protected CerbosResult(CerbosResultBuilder<?, ?> b) {
            this.resource = b.resource;
            this.actions = b.actions;
            this.validationErrors = b.validationErrors;
            this.meta = b.meta;
        }

        @Generated
        public static CerbosResultBuilder<?, ?> builder() {
            return new CerbosResultBuilderImpl();
        }

        @Generated
        public CerbosResource getResource() {
            return this.resource;
        }

        @Generated
        public Map<String, Actions> getActions() {
            return this.actions;
        }

        @Generated
        public Map<String, Actions> getValidationErrors() {
            return this.validationErrors;
        }

        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @Generated
        public CerbosResult setResource(CerbosResource resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public CerbosResult setActions(Map<String, Actions> actions) {
            this.actions = actions;
            return this;
        }

        @Generated
        public CerbosResult setValidationErrors(Map<String, Actions> validationErrors) {
            this.validationErrors = validationErrors;
            return this;
        }

        @Generated
        public CerbosResult setMeta(Map<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        @Generated
        public CerbosResult(CerbosResource resource, Map<String, Actions> actions, Map<String, Actions> validationErrors, Map<String, Object> meta) {
            this.resource = resource;
            this.actions = actions;
            this.validationErrors = validationErrors;
            this.meta = meta;
        }

        @Generated
        public CerbosResult() {
        }

        @Generated
        public String toString() {
            return "CerbosRegisteredServiceAccessStrategy.CerbosResult(resource=" + String.valueOf(this.resource) + ", actions=" + String.valueOf(this.actions) + ", validationErrors=" + String.valueOf(this.validationErrors) + ", meta=" + String.valueOf(this.meta) + ")";
        }

        @Generated
        public static abstract class CerbosResultBuilder<C extends CerbosResult, B extends CerbosResultBuilder<C, B>> {
            @Generated
            private CerbosResource resource;
            @Generated
            private Map<String, Actions> actions;
            @Generated
            private Map<String, Actions> validationErrors;
            @Generated
            private Map<String, Object> meta;

            @Generated
            public B resource(CerbosResource resource) {
                this.resource = resource;
                return this.self();
            }

            @Generated
            public B actions(Map<String, Actions> actions) {
                this.actions = actions;
                return this.self();
            }

            @Generated
            public B validationErrors(Map<String, Actions> validationErrors) {
                this.validationErrors = validationErrors;
                return this.self();
            }

            @Generated
            public B meta(Map<String, Object> meta) {
                this.meta = meta;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "CerbosRegisteredServiceAccessStrategy.CerbosResult.CerbosResultBuilder(resource=" + String.valueOf(this.resource) + ", actions=" + String.valueOf(this.actions) + ", validationErrors=" + String.valueOf(this.validationErrors) + ", meta=" + String.valueOf(this.meta) + ")";
            }
        }

        @Generated
        private static final class CerbosResultBuilderImpl
        extends CerbosResultBuilder<CerbosResult, CerbosResultBuilderImpl> {
            @Generated
            private CerbosResultBuilderImpl() {
            }

            @Override
            @Generated
            protected CerbosResultBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CerbosResult build() {
                return new CerbosResult(this);
            }
        }
    }

    private static enum Actions {
        EFFECT_UNSPECIFIED,
        EFFECT_ALLOW,
        EFFECT_DENY,
        EFFECT_NO_MATCH;

    }
}

