/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.audit.BaseAuditableExecution;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyEnforcer;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServicePrincipalAccessStrategyEnforcer;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.inspektr.audit.annotation.Audit;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class RegisteredServiceAccessStrategyAuditableEnforcer
extends BaseAuditableExecution {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceAccessStrategyAuditableEnforcer.class);
    private final ConfigurableApplicationContext applicationContext;
    private final RegisteredServicePrincipalAccessStrategyEnforcer principalAccessStrategyEnforcer;

    private Optional<AuditableExecutionResult> byServiceTicketAndAuthnResultAndRegisteredService(AuditableContext context) {
        Optional providedRegisteredService = context.getRegisteredService();
        if (context.getServiceTicket().isPresent() && context.getAuthenticationResult().isPresent() && providedRegisteredService.isPresent()) {
            AuditableExecutionResult result = AuditableExecutionResult.of((AuditableContext)context);
            try {
                ServiceTicket serviceTicket = (ServiceTicket)context.getServiceTicket().orElseThrow();
                Authentication authResult = ((AuthenticationResult)context.getAuthenticationResult().orElseThrow()).getAuthentication();
                this.ensurePrincipalAccessIsAllowedForService((RegisteredService)providedRegisteredService.get(), serviceTicket.getService(), authResult);
            }
            catch (Throwable e) {
                result.setException(e);
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private Optional<AuditableExecutionResult> byServiceAndRegisteredServiceAndTicketGrantingTicket(AuditableContext context) {
        Optional providedService = context.getService();
        Optional providedRegisteredService = context.getRegisteredService();
        Optional ticketGrantingTicket = context.getTicketGrantingTicket();
        if (providedService.isPresent() && providedRegisteredService.isPresent() && ticketGrantingTicket.isPresent()) {
            RegisteredService registeredService = (RegisteredService)providedRegisteredService.get();
            Service service = (Service)providedService.get();
            AuditableExecutionResult result = AuditableExecutionResult.builder().registeredService(registeredService).service(service).ticketGrantingTicket((TicketGrantingTicket)ticketGrantingTicket.get()).build();
            try {
                Authentication authResult = ((TicketGrantingTicket)ticketGrantingTicket.get()).getRoot().getAuthentication();
                this.ensurePrincipalAccessIsAllowedForService(registeredService, service, authResult);
            }
            catch (Throwable e) {
                result.setException(e);
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    protected void ensurePrincipalAccessIsAllowedForService(RegisteredService registeredService, Service service, Authentication authentication) throws Throwable {
        Map attributes = CollectionUtils.merge((Map[])new Map[]{authentication.getAttributes(), authentication.getPrincipal().getAttributes()});
        this.principalAccessStrategyEnforcer.authorize((RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext)((RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.PrincipalAccessStrategyContextBuilder)((RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.PrincipalAccessStrategyContextBuilder)((RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.PrincipalAccessStrategyContextBuilder)((RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.PrincipalAccessStrategyContextBuilder)((RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.PrincipalAccessStrategyContextBuilder)RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.builder().registeredService(registeredService)).principalId(authentication.getPrincipal().getId())).principalAttributes(attributes)).service(service)).applicationContext((ApplicationContext)this.applicationContext)).build());
    }

    private static Optional<AuditableExecutionResult> byRegisteredService(AuditableContext context) {
        Optional providedRegisteredService = context.getRegisteredService();
        if (providedRegisteredService.isPresent()) {
            RegisteredService registeredService = (RegisteredService)providedRegisteredService.get();
            AuditableExecutionResult result = AuditableExecutionResult.builder().registeredService(registeredService).service((Service)context.getService().orElse(null)).authentication((Authentication)context.getAuthentication().orElse(null)).build();
            try {
                RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed(registeredService);
            }
            catch (PrincipalException | UnauthorizedServiceException e) {
                result.setException(e);
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private static Optional<AuditableExecutionResult> byServiceAndRegisteredService(AuditableContext context) {
        Optional providedService = context.getService();
        Optional providedRegisteredService = context.getRegisteredService();
        if (providedService.isPresent() && providedRegisteredService.isPresent()) {
            RegisteredService registeredService = (RegisteredService)providedRegisteredService.get();
            Service service = (Service)providedService.get();
            AuditableExecutionResult result = AuditableExecutionResult.builder().registeredService(registeredService).service(service).build();
            try {
                RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed(service, registeredService);
            }
            catch (PrincipalException | UnauthorizedServiceException e) {
                result.setException(e);
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private Optional<AuditableExecutionResult> byServiceAndRegisteredServiceAndPrincipal(AuditableContext context) {
        Optional providedService = context.getService();
        Optional providedRegisteredService = context.getRegisteredService();
        Optional providedPrincipal = context.getPrincipal();
        if (providedService.isPresent() && providedRegisteredService.isPresent() && providedPrincipal.isPresent()) {
            RegisteredService registeredService = (RegisteredService)providedRegisteredService.get();
            Service service = (Service)providedService.get();
            Principal principal = (Principal)providedPrincipal.get();
            AuditableExecutionResult result = AuditableExecutionResult.builder().registeredService(registeredService).service(service).build();
            try {
                this.principalAccessStrategyEnforcer.authorize((RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext)((RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.PrincipalAccessStrategyContextBuilder)((RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.PrincipalAccessStrategyContextBuilder)((RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.PrincipalAccessStrategyContextBuilder)((RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.PrincipalAccessStrategyContextBuilder)((RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.PrincipalAccessStrategyContextBuilder)RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.builder().registeredService(registeredService)).principalId(principal.getId())).principalAttributes(principal.getAttributes())).service(service)).applicationContext((ApplicationContext)this.applicationContext)).build());
            }
            catch (Throwable e) {
                result.setException(e);
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private Optional<AuditableExecutionResult> byServiceAndRegisteredServiceAndAuthentication(AuditableContext context) {
        Optional providedService = context.getService();
        Optional providedRegisteredService = context.getRegisteredService();
        Optional providedAuthn = context.getAuthentication();
        if (providedService.isPresent() && providedRegisteredService.isPresent() && providedAuthn.isPresent()) {
            RegisteredService registeredService = (RegisteredService)providedRegisteredService.get();
            Service service = (Service)providedService.get();
            Authentication authentication = (Authentication)providedAuthn.get();
            AuditableExecutionResult result = AuditableExecutionResult.builder().registeredService(registeredService).service(service).authentication(authentication).build();
            try {
                this.ensurePrincipalAccessIsAllowedForService(registeredService, service, authentication);
            }
            catch (Throwable e) {
                result.setException(e);
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    @Audit(action="SERVICE_ACCESS_ENFORCEMENT", actionResolverName="SERVICE_ACCESS_ENFORCEMENT_ACTION_RESOLVER", resourceResolverName="SERVICE_ACCESS_ENFORCEMENT_RESOURCE_RESOLVER")
    public AuditableExecutionResult execute(AuditableContext context) {
        return this.byExternalAccessStrategyEnforcers(context).or(() -> this.byServiceTicketAndAuthnResultAndRegisteredService(context)).or(() -> this.byServiceAndRegisteredServiceAndTicketGrantingTicket(context)).or(() -> this.byServiceAndRegisteredServiceAndPrincipal(context)).or(() -> this.byServiceAndRegisteredServiceAndAuthentication(context)).or(() -> RegisteredServiceAccessStrategyAuditableEnforcer.byServiceAndRegisteredService(context)).or(() -> RegisteredServiceAccessStrategyAuditableEnforcer.byRegisteredService(context)).orElseGet(() -> {
            AuditableExecutionResult result = AuditableExecutionResult.builder().registeredService((RegisteredService)context.getRegisteredService().orElse(null)).service((Service)context.getService().orElse(null)).authentication((Authentication)context.getAuthentication().orElse(null)).build();
            result.setException((Throwable)UnauthorizedServiceException.denied((String)"Unauthorized"));
            LOGGER.warn("Service is not registered in the service registry. Service is [{}] and registered service is [{}]", result.getService().orElse(null), result.getRegisteredService().orElse(null));
            return result;
        });
    }

    protected Optional<AuditableExecutionResult> byExternalAccessStrategyEnforcers(AuditableContext context) {
        Collection enforcers = this.applicationContext.getBeansOfType(RegisteredServiceAccessStrategyEnforcer.class).values();
        return enforcers.stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<RegisteredServiceAccessStrategyEnforcer>)AnnotationAwareOrderComparator.INSTANCE).map(Unchecked.function(enforcer -> enforcer.execute(context))).filter(Objects::nonNull).filter(AuditableExecutionResult::isExecutionFailure).findFirst();
    }

    @Generated
    public RegisteredServiceAccessStrategyAuditableEnforcer(ConfigurableApplicationContext applicationContext, RegisteredServicePrincipalAccessStrategyEnforcer principalAccessStrategyEnforcer) {
        this.applicationContext = applicationContext;
        this.principalAccessStrategyEnforcer = principalAccessStrategyEnforcer;
    }
}

