/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.federation;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatementClaimsSet;
import com.nimbusds.openid.connect.sdk.federation.entities.FederationEntityMetadata;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.time.Clock;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.federation.OidcFederationEntityStatementService;
import org.apereo.cas.oidc.federation.OidcFederationJsonWebKeystoreService;
import org.apereo.cas.util.DateTimeUtils;

public class OidcFederationDefaultEntityStatementService
implements OidcFederationEntityStatementService {
    private final OidcFederationJsonWebKeystoreService jsonWebKeystoreService;
    private final OidcServerDiscoverySettings serverDiscoverySettings;
    private final OidcProperties oidcProperties;

    @Override
    public EntityStatement createAndSign() throws Exception {
        EntityID iss = new EntityID(this.serverDiscoverySettings.getIssuer());
        EntityID sub = new EntityID(this.serverDiscoverySettings.getIssuer());
        Date iat = DateTimeUtils.dateOf((LocalDate)LocalDate.now(Clock.systemUTC()));
        Date exp = DateTimeUtils.dateOf((LocalDate)LocalDate.now(Clock.systemUTC()).plusYears(10L));
        EntityStatementClaimsSet claims = new EntityStatementClaimsSet(iss, sub, iat, exp, this.jsonWebKeystoreService.toJWKSet());
        List<EntityID> authorityHints = this.oidcProperties.getFederation().getAuthorityHints().stream().map(EntityID::new).toList();
        claims.setAuthorityHints(authorityHints);
        String discovery = this.serverDiscoverySettings.toJson();
        OIDCProviderMetadata opMetadata = OIDCProviderMetadata.parse((String)discovery);
        claims.setOPMetadata(opMetadata);
        FederationEntityMetadata fedMeta = new FederationEntityMetadata();
        fedMeta.setOrganizationName(this.oidcProperties.getFederation().getOrganization());
        fedMeta.setContacts(this.oidcProperties.getFederation().getContacts());
        claims.setFederationEntityMetadata(fedMeta);
        return this.jsonWebKeystoreService.signEntityStatement(claims);
    }

    @Generated
    public OidcFederationDefaultEntityStatementService(OidcFederationJsonWebKeystoreService jsonWebKeystoreService, OidcServerDiscoverySettings serverDiscoverySettings, OidcProperties oidcProperties) {
        this.jsonWebKeystoreService = jsonWebKeystoreService;
        this.serverDiscoverySettings = serverDiscoverySettings;
        this.oidcProperties = oidcProperties;
    }
}

