/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.slo;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apereo.cas.logout.slo.SingleLogoutExecutionRequest;
import org.apereo.cas.logout.slo.SingleLogoutMessage;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutRequestContext;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.DigestUtils;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class OidcSingleLogoutMessageCreator
implements SingleLogoutMessageCreator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcSingleLogoutMessageCreator.class);
    protected final ObjectProvider<OidcConfigurationContext> configurationProvider;

    public SingleLogoutMessage create(SingleLogoutRequestContext request) throws Throwable {
        OidcConfigurationContext configurationContext = (OidcConfigurationContext)((Object)this.configurationProvider.getObject());
        SingleLogoutMessage.SingleLogoutMessageBuilder builder = SingleLogoutMessage.builder();
        LOGGER.trace("Building logout token for [{}]", (Object)request.getRegisteredService());
        JwtClaims claims = this.buildJwtClaims(request);
        String logoutToken = configurationContext.getIdTokenSigningAndEncryptionService().encode((OAuthRegisteredService)request.getRegisteredService(), claims);
        return builder.payload(logoutToken).build();
    }

    protected JwtClaims buildJwtClaims(SingleLogoutRequestContext request) {
        SingleLogoutExecutionRequest executionRequest = request.getExecutionRequest();
        JwtClaims claims = new JwtClaims();
        claims.setSubject(executionRequest.getTicketGrantingTicket().getAuthentication().getPrincipal().getId());
        String sid = DigestUtils.sha((String)DigestUtils.sha512((String)executionRequest.getTicketGrantingTicket().getId()));
        claims.setClaim("sid", (Object)sid);
        claims.setIssuer(this.determineIssuer(request));
        claims.setAudience(((OAuthRegisteredService)request.getRegisteredService()).getClientId());
        claims.setIssuedAtToNow();
        claims.setJwtId(UUID.randomUUID().toString());
        claims.setExpirationTimeMinutesInTheFuture(1.0f);
        HashMap events = new HashMap();
        events.put("http://schemas.openid.net/event/backchannel-logout", new HashMap());
        claims.setClaim("events", events);
        return claims;
    }

    protected String determineIssuer(SingleLogoutRequestContext sloRequest) {
        OidcConfigurationContext configurationContext = (OidcConfigurationContext)((Object)this.configurationProvider.getObject());
        RegisteredService registeredService = sloRequest.getRegisteredService();
        if (registeredService instanceof OidcRegisteredService) {
            OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)registeredService;
            return configurationContext.getIssuerService().determineIssuer(Optional.of(oidcRegisteredService));
        }
        return configurationContext.getIssuerService().determineIssuer(Optional.empty());
    }

    @Generated
    public OidcSingleLogoutMessageCreator(ObjectProvider<OidcConfigurationContext> configurationProvider) {
        this.configurationProvider = configurationProvider;
    }
}

