/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequest;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestFactory;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.views.OAuth20ConsentApprovalViewResolver;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcConsentApprovalViewResolver
extends OAuth20ConsentApprovalViewResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcConsentApprovalViewResolver.class);
    private final TicketRegistry ticketRegistry;
    private final TicketFactory ticketFactory;
    private final OAuth20RequestParameterResolver oauthRequestParameterResolver;

    public OidcConsentApprovalViewResolver(CasConfigurationProperties casProperties, SessionStore sessionStore, TicketRegistry ticketRegistry, TicketFactory ticketFactory, OAuth20RequestParameterResolver oauthRequestParameterResolver) {
        super(casProperties, sessionStore);
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        this.oauthRequestParameterResolver = oauthRequestParameterResolver;
    }

    protected boolean isConsentApprovalBypassed(WebContext context, OAuthRegisteredService service) {
        if (service instanceof OidcRegisteredService) {
            if (context.getRequestURL().endsWith("oidcPushAuthorize")) {
                LOGGER.trace("Consent approval is bypassed for pushed authorization requests");
                return true;
            }
            Set prompts = this.oauthRequestParameterResolver.resolveSupportedPromptValues(context);
            if (prompts.contains("consent")) {
                return false;
            }
        }
        return super.isConsentApprovalBypassed(context, service);
    }

    protected String getApprovalViewName() {
        return "oidcConfirmView";
    }

    protected void prepareApprovalViewModel(Map<String, Object> model, WebContext webContext, OAuthRegisteredService registeredService) throws Exception {
        super.prepareApprovalViewModel(model, webContext, registeredService);
        if (registeredService instanceof OidcRegisteredService) {
            OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)registeredService;
            String dynamicRegistrationPropName = RegisteredServiceProperty.RegisteredServiceProperties.OIDC_DYNAMIC_CLIENT_REGISTRATION.getPropertyName();
            if (oidcRegisteredService.getProperties().containsKey(dynamicRegistrationPropName)) {
                boolean dynamic = ((RegisteredServiceProperty)oidcRegisteredService.getProperties().get(dynamicRegistrationPropName)).getBooleanValue();
                model.put("dynamic", dynamic);
                model.put("dynamicTime", ((RegisteredServiceProperty)oidcRegisteredService.getProperties().get(RegisteredServiceProperty.RegisteredServiceProperties.OIDC_DYNAMIC_CLIENT_REGISTRATION_DATE.getPropertyName())).getValue(String.class));
            }
            HashSet<String> supportedScopes = new HashSet<String>(this.casProperties.getAuthn().getOidc().getDiscovery().getScopes());
            supportedScopes.retainAll(oidcRegisteredService.getScopes());
            Collection requestedScopes = this.oauthRequestParameterResolver.resolveRequestedScopes(webContext);
            Set userInfoClaims = this.oauthRequestParameterResolver.resolveUserInfoRequestClaims(webContext);
            webContext.getRequestParameter("request_uri").ifPresent(Unchecked.consumer(uri -> {
                OidcPushedAuthorizationRequest authzRequest = (OidcPushedAuthorizationRequest)this.ticketRegistry.getTicket(uri, OidcPushedAuthorizationRequest.class);
                OidcPushedAuthorizationRequestFactory uriFactory = (OidcPushedAuthorizationRequestFactory)this.ticketFactory.get(OidcPushedAuthorizationRequest.class);
                AccessTokenRequestContext holder = uriFactory.toAccessTokenRequest(authzRequest);
                userInfoClaims.addAll(holder.getClaims().keySet());
                requestedScopes.addAll(holder.getScopes());
            }));
            supportedScopes.retainAll(requestedScopes);
            supportedScopes.add(OidcConstants.StandardScopes.OPENID.getScope());
            model.put("scopes", supportedScopes);
            model.put("userInfoClaims", userInfoClaims);
        }
    }
}

