/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import org.apache.commons.lang3.Strings;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeBuilder;

public interface OAuth20ResponseModeFactory {
    public static final String BEAN_NAME = "oauthResponseModeFactory";

    public static boolean isResponseModeTypeFormPostJwt(OAuthRegisteredService registeredService, OAuth20ResponseModeTypes responseType) {
        return responseType == OAuth20ResponseModeTypes.FORM_POST_JWT || registeredService != null && Strings.CI.equals(OAuth20ResponseModeTypes.FORM_POST_JWT.getType(), registeredService.getResponseMode());
    }

    public static boolean isResponseModeTypeFormPost(OAuthRegisteredService registeredService, OAuth20ResponseModeTypes responseType) {
        return responseType == OAuth20ResponseModeTypes.FORM_POST || registeredService != null && (Strings.CI.equals("post", registeredService.getResponseMode()) || Strings.CI.equals(OAuth20ResponseModeTypes.FORM_POST.getType(), registeredService.getResponseMode()));
    }

    public static boolean isResponseModeTypeFragment(OAuthRegisteredService registeredService, OAuth20ResponseModeTypes responseType) {
        return responseType == OAuth20ResponseModeTypes.FRAGMENT || registeredService != null && Strings.CI.equals(OAuth20ResponseModeTypes.FRAGMENT.getType(), registeredService.getResponseMode());
    }

    public static boolean isResponseModeTypeFragmentJwt(OAuthRegisteredService registeredService, OAuth20ResponseModeTypes responseType) {
        return responseType == OAuth20ResponseModeTypes.FRAGMENT_JWT || registeredService != null && Strings.CI.equals(OAuth20ResponseModeTypes.FRAGMENT_JWT.getType(), registeredService.getResponseMode());
    }

    public static boolean isResponseModeTypeQueryJwt(OAuthRegisteredService registeredService, OAuth20ResponseModeTypes responseType) {
        return responseType == OAuth20ResponseModeTypes.QUERY_JWT || registeredService != null && Strings.CI.equals(OAuth20ResponseModeTypes.QUERY_JWT.getType(), registeredService.getResponseMode());
    }

    public OAuth20ResponseModeFactory registerBuilder(OAuth20ResponseModeBuilder var1);

    public OAuth20ResponseModeBuilder getBuilder(OAuthRegisteredService var1, OAuth20ResponseModeTypes var2);
}

