/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.graphite;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class GraphiteDimensionalNamingConvention
implements NamingConvention {
    private static final Pattern PATTERN_NAME_BLACKLISTED_CHARS = Pattern.compile("[{}(),=\\[\\]/ ?:;]");
    private static final Pattern PATTERN_TAG_KEY_BLACKLISTED_CHARS = Pattern.compile("[;!^=]");
    private static final Pattern PATTERN_TAG_VALUE_BLACKLISTED_CHARS = Pattern.compile("[;~]");
    private static final String UNSPECIFIED = "unspecified";
    private final NamingConvention delegate;

    public GraphiteDimensionalNamingConvention() {
        this(NamingConvention.dot);
    }

    public GraphiteDimensionalNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return this.sanitizeName(this.delegate.name(this.normalize(name), type, baseUnit));
    }

    public String tagKey(String key) {
        if (key.isEmpty()) {
            return UNSPECIFIED;
        }
        return this.sanitizeTagKey(this.delegate.tagKey(this.normalize(key)));
    }

    public String tagValue(String value) {
        if (value.isEmpty()) {
            return UNSPECIFIED;
        }
        return this.sanitizeTagValue(this.delegate.tagValue(this.normalize(value)));
    }

    private String normalize(String name) {
        return Normalizer.normalize(name, Normalizer.Form.NFKD);
    }

    private String sanitizeName(String delegated) {
        return PATTERN_NAME_BLACKLISTED_CHARS.matcher(delegated).replaceAll("_");
    }

    private String sanitizeTagKey(String delegated) {
        return PATTERN_TAG_KEY_BLACKLISTED_CHARS.matcher(delegated).replaceAll("_");
    }

    private String sanitizeTagValue(String delegated) {
        return PATTERN_TAG_VALUE_BLACKLISTED_CHARS.matcher(delegated).replaceAll("_");
    }
}

