/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.io.File;
import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FileLockTest {
    FileLockTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLock() throws IOException {
        File tempFile = TestUtils.tempFile();
        FileLock lock1 = new FileLock(tempFile);
        try {
            lock1.lock();
            Assertions.assertThrows(OverlappingFileLockException.class, () -> ((FileLock)lock1).lock());
            FileLock lock2 = new FileLock(tempFile);
            Assertions.assertThrows(OverlappingFileLockException.class, () -> ((FileLock)lock2).lock());
            Assertions.assertFalse((boolean)lock2.tryLock());
            lock1.unlock();
        }
        finally {
            lock1.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testTryLock() throws IOException {
        File tempFile = TestUtils.tempFile();
        FileLock lock1 = new FileLock(tempFile);
        try {
            Assertions.assertTrue((boolean)lock1.tryLock());
            Assertions.assertFalse((boolean)lock1.tryLock());
            FileLock lock2 = new FileLock(tempFile);
            Assertions.assertFalse((boolean)lock2.tryLock());
            Assertions.assertThrows(OverlappingFileLockException.class, () -> ((FileLock)lock2).lock());
            lock1.unlock();
        }
        finally {
            lock1.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testUnlock() throws IOException {
        File tempFile = TestUtils.tempFile();
        FileLock lock1 = new FileLock(tempFile);
        try {
            lock1.lock();
            lock1.unlock();
            lock1.lock();
            lock1.unlock();
            Assertions.assertTrue((boolean)lock1.tryLock());
            lock1.unlock();
            Assertions.assertTrue((boolean)lock1.tryLock());
            lock1.unlock();
            FileLock lock2 = new FileLock(tempFile);
            Assertions.assertTrue((boolean)lock2.tryLock());
            lock2.unlock();
            Assertions.assertDoesNotThrow(() -> ((FileLock)lock2).lock());
            lock2.unlock();
        }
        finally {
            lock1.destroy();
        }
    }

    @Test
    void testDestroy() throws IOException {
        File tempFile = TestUtils.tempFile();
        FileLock lock1 = new FileLock(tempFile);
        lock1.destroy();
        Assertions.assertFalse((boolean)tempFile.exists());
        Assertions.assertDoesNotThrow(() -> ((FileLock)lock1).destroy());
    }
}

