/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.configuration;

import com.icegreen.greenmail.configuration.UserBean;
import java.util.ArrayList;
import java.util.List;

public class GreenMailConfiguration {
    private final List<UserBean> usersToCreate = new ArrayList<UserBean>();
    private boolean disableAuthenticationCheck = false;
    private boolean sieveIgnoreDetail = false;
    private String preloadDir;

    public GreenMailConfiguration withUser(String login, String password) {
        return this.withUser(login, login, password);
    }

    public GreenMailConfiguration withUser(String email, String login, String password) {
        this.usersToCreate.add(new UserBean(email, login, password));
        return this;
    }

    public static GreenMailConfiguration aConfig() {
        return new GreenMailConfiguration();
    }

    public List<UserBean> getUsersToCreate() {
        return this.usersToCreate;
    }

    public GreenMailConfiguration withDisabledAuthentication() {
        this.disableAuthenticationCheck = true;
        return this;
    }

    public boolean isAuthenticationDisabled() {
        return this.disableAuthenticationCheck;
    }

    public GreenMailConfiguration withSieveIgnoreDetail() {
        this.sieveIgnoreDetail = true;
        return this;
    }

    public boolean isSieveIgnoreDetailEnabled() {
        return this.sieveIgnoreDetail;
    }

    public GreenMailConfiguration withPreloadDir(String preloadDir) {
        this.preloadDir = preloadDir;
        return this;
    }

    public String getPreloadDir() {
        return this.preloadDir;
    }

    public boolean hasPreloadDir() {
        return null != this.preloadDir;
    }
}

