/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl;

import java.io.InputStream;
import java.util.List;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.api.ChannelDefinitionQuery;
import org.flowable.eventregistry.api.EventDefinition;
import org.flowable.eventregistry.api.EventDefinitionQuery;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.api.EventDeploymentBuilder;
import org.flowable.eventregistry.api.EventDeploymentQuery;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.model.EventModelBuilder;
import org.flowable.eventregistry.api.model.InboundChannelModelBuilder;
import org.flowable.eventregistry.api.model.OutboundChannelModelBuilder;
import org.flowable.eventregistry.impl.ChannelDefinitionQueryImpl;
import org.flowable.eventregistry.impl.EventDefinitionQueryImpl;
import org.flowable.eventregistry.impl.EventDeploymentQueryImpl;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.cmd.DeleteDeploymentCmd;
import org.flowable.eventregistry.impl.cmd.DeployCmd;
import org.flowable.eventregistry.impl.cmd.GetChannelDefinitionCmd;
import org.flowable.eventregistry.impl.cmd.GetChannelDefinitionResourceCmd;
import org.flowable.eventregistry.impl.cmd.GetChannelModelCmd;
import org.flowable.eventregistry.impl.cmd.GetDeploymentResourceCmd;
import org.flowable.eventregistry.impl.cmd.GetDeploymentResourceNamesCmd;
import org.flowable.eventregistry.impl.cmd.GetEventDefinitionCmd;
import org.flowable.eventregistry.impl.cmd.GetEventDefinitionResourceCmd;
import org.flowable.eventregistry.impl.cmd.GetEventModelCmd;
import org.flowable.eventregistry.impl.cmd.SetChannelDefinitionCategoryCmd;
import org.flowable.eventregistry.impl.cmd.SetDeploymentCategoryCmd;
import org.flowable.eventregistry.impl.cmd.SetDeploymentParentDeploymentIdCmd;
import org.flowable.eventregistry.impl.cmd.SetDeploymentTenantIdCmd;
import org.flowable.eventregistry.impl.cmd.SetEventDefinitionCategoryCmd;
import org.flowable.eventregistry.impl.model.EventModelBuilderImpl;
import org.flowable.eventregistry.impl.model.InboundChannelDefinitionBuilderImpl;
import org.flowable.eventregistry.impl.model.OutboundChannelDefinitionBuilderImpl;
import org.flowable.eventregistry.impl.repository.EventDeploymentBuilderImpl;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.EventModel;

public class EventRepositoryServiceImpl
extends CommonEngineServiceImpl<EventRegistryEngineConfiguration>
implements EventRepositoryService {
    protected EventRegistryEngineConfiguration eventRegistryEngineConfiguration;

    public EventRepositoryServiceImpl(EventRegistryEngineConfiguration engineConfiguration) {
        super((AbstractEngineConfiguration)engineConfiguration);
        this.eventRegistryEngineConfiguration = engineConfiguration;
    }

    public EventDeploymentBuilder createDeployment() {
        return (EventDeploymentBuilder)this.commandExecutor.execute((Command)new Command<EventDeploymentBuilder>(){

            public EventDeploymentBuilder execute(CommandContext commandContext) {
                return new EventDeploymentBuilderImpl();
            }
        });
    }

    public EventDeployment deploy(EventDeploymentBuilderImpl deploymentBuilder) {
        return (EventDeployment)this.commandExecutor.execute(new DeployCmd(deploymentBuilder));
    }

    public void deleteDeployment(String deploymentId) {
        this.commandExecutor.execute((Command)new DeleteDeploymentCmd(deploymentId));
    }

    public EventDefinitionQuery createEventDefinitionQuery() {
        return new EventDefinitionQueryImpl(this.commandExecutor);
    }

    public ChannelDefinitionQuery createChannelDefinitionQuery() {
        return new ChannelDefinitionQueryImpl(this.commandExecutor);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return (List)this.commandExecutor.execute((Command)new GetDeploymentResourceNamesCmd(deploymentId));
    }

    public InputStream getResourceAsStream(String deploymentId, String resourceName) {
        return (InputStream)this.commandExecutor.execute((Command)new GetDeploymentResourceCmd(deploymentId, resourceName));
    }

    public void setDeploymentCategory(String deploymentId, String category) {
        this.commandExecutor.execute((Command)new SetDeploymentCategoryCmd(deploymentId, category));
    }

    public void setDeploymentTenantId(String deploymentId, String newTenantId) {
        this.commandExecutor.execute((Command)new SetDeploymentTenantIdCmd(deploymentId, newTenantId));
    }

    public void changeDeploymentParentDeploymentId(String deploymentId, String newParentDeploymentId) {
        this.commandExecutor.execute((Command)new SetDeploymentParentDeploymentIdCmd(deploymentId, newParentDeploymentId));
    }

    public EventDeploymentQuery createDeploymentQuery() {
        return new EventDeploymentQueryImpl(this.commandExecutor);
    }

    public EventDefinition getEventDefinition(String eventDefinitionId) {
        return (EventDefinition)this.commandExecutor.execute((Command)new GetEventDefinitionCmd(eventDefinitionId));
    }

    public InputStream getEventDefinitionResource(String eventDefinitionId) {
        return (InputStream)this.commandExecutor.execute((Command)new GetEventDefinitionResourceCmd(eventDefinitionId));
    }

    public void setEventDefinitionCategory(String eventDefinitionId, String category) {
        this.commandExecutor.execute((Command)new SetEventDefinitionCategoryCmd(eventDefinitionId, category));
    }

    public ChannelDefinition getChannelDefinition(String channelDefinitionId) {
        return (ChannelDefinition)this.commandExecutor.execute((Command)new GetChannelDefinitionCmd(channelDefinitionId));
    }

    public InputStream getChannelDefinitionResource(String channelDefinitionId) {
        return (InputStream)this.commandExecutor.execute((Command)new GetChannelDefinitionResourceCmd(channelDefinitionId));
    }

    public void setChannelDefinitionCategory(String channelDefinitionId, String category) {
        this.commandExecutor.execute((Command)new SetChannelDefinitionCategoryCmd(channelDefinitionId, category));
    }

    public EventModel getEventModelById(String eventDefinitionId) {
        return (EventModel)this.commandExecutor.execute((Command)new GetEventModelCmd(null, eventDefinitionId));
    }

    public EventModel getEventModelByKey(String eventDefinitionKey) {
        return (EventModel)this.commandExecutor.execute((Command)new GetEventModelCmd(eventDefinitionKey, null));
    }

    public EventModel getEventModelByKey(String eventDefinitionKey, String tenantId) {
        return (EventModel)this.commandExecutor.execute((Command)new GetEventModelCmd(eventDefinitionKey, tenantId, null));
    }

    public EventModel getEventModelByKeyAndParentDeploymentId(String eventDefinitionKey, String parentDeploymentId) {
        return (EventModel)this.commandExecutor.execute((Command)new GetEventModelCmd(eventDefinitionKey, null, parentDeploymentId));
    }

    public EventModel getEventModelByKeyAndParentDeploymentId(String eventDefinitionKey, String parentDeploymentId, String tenantId) {
        return (EventModel)this.commandExecutor.execute((Command)new GetEventModelCmd(eventDefinitionKey, tenantId, parentDeploymentId));
    }

    public ChannelModel getChannelModelById(String channelDefinitionId) {
        return (ChannelModel)this.commandExecutor.execute((Command)new GetChannelModelCmd(null, channelDefinitionId));
    }

    public ChannelModel getChannelModelByKey(String channelDefinitionKey) {
        return (ChannelModel)this.commandExecutor.execute((Command)new GetChannelModelCmd(channelDefinitionKey, null));
    }

    public ChannelModel getChannelModelByKey(String channelDefinitionKey, String tenantId) {
        return (ChannelModel)this.commandExecutor.execute((Command)new GetChannelModelCmd(channelDefinitionKey, tenantId, null));
    }

    public ChannelModel getChannelModelByKeyAndParentDeploymentId(String channelDefinitionKey, String parentDeploymentId) {
        return (ChannelModel)this.commandExecutor.execute((Command)new GetChannelModelCmd(channelDefinitionKey, null, parentDeploymentId));
    }

    public ChannelModel getChannelModelByKeyAndParentDeploymentId(String channelDefinitionKey, String parentDeploymentId, String tenantId) {
        return (ChannelModel)this.commandExecutor.execute((Command)new GetChannelModelCmd(channelDefinitionKey, tenantId, parentDeploymentId));
    }

    public EventModelBuilder createEventModelBuilder() {
        return new EventModelBuilderImpl(this, this.eventRegistryEngineConfiguration.getEventJsonConverter());
    }

    public InboundChannelModelBuilder createInboundChannelModelBuilder() {
        return new InboundChannelDefinitionBuilderImpl(this, this.eventRegistryEngineConfiguration.getChannelJsonConverter());
    }

    public OutboundChannelModelBuilder createOutboundChannelModelBuilder() {
        return new OutboundChannelDefinitionBuilderImpl(this, this.eventRegistryEngineConfiguration.getChannelJsonConverter());
    }

    public void registerEventModel(EventModel eventModel) {
    }
}

