/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20ClientIdAwareProfileManager
extends ProfileManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ClientIdAwareProfileManager.class);
    private static final String SESSION_CLIENT_ID = "oauthClientId";
    private final ServicesManager servicesManager;
    private final OAuth20RequestParameterResolver requestParameterResolver;

    public OAuth20ClientIdAwareProfileManager(WebContext context, SessionStore sessionStore, ServicesManager servicesManager, OAuth20RequestParameterResolver requestParameterResolver) {
        super(context, sessionStore);
        this.servicesManager = servicesManager;
        this.requestParameterResolver = requestParameterResolver;
    }

    protected LinkedHashMap<String, UserProfile> retrieveAll(boolean readFromSession) {
        Set profiles = super.retrieveAll(readFromSession).entrySet();
        String clientId = this.getClientIdFromRequest();
        LinkedHashMap results = profiles.stream().filter(it -> {
            UserProfile profile = (UserProfile)it.getValue();
            return StringUtils.isBlank((CharSequence)clientId) || Strings.CI.equals((CharSequence)profile.getAttribute(SESSION_CLIENT_ID), (CharSequence)clientId);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
            throw new IllegalStateException("Duplicate key");
        }, LinkedHashMap::new));
        LOGGER.trace("Fetched profiles for this session are [{}]", (Object)results);
        return results;
    }

    public void save(boolean saveInSession, UserProfile profile, boolean multiProfile) {
        String clientId = this.getClientIdFromRequest();
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            profile.addAttribute(SESSION_CLIENT_ID, (Object)clientId);
        }
        super.save(saveInSession, profile, multiProfile);
    }

    private String getClientIdFromRequest() {
        String clientId = this.requestParameterResolver.resolveRequestParameter(this.context, "client_id").map(String::valueOf).orElse("");
        if (StringUtils.isBlank((CharSequence)clientId)) {
            String redirectUri = this.requestParameterResolver.resolveRequestParameter(this.context, "redirect_uri").map(String::valueOf).orElse("");
            OAuth20Utils.validateRedirectUri(redirectUri);
            OAuthRegisteredService svc = OAuth20Utils.getRegisteredOAuthServiceByRedirectUri(this.servicesManager, redirectUri);
            clientId = svc != null ? svc.getClientId() : "";
        }
        return clientId;
    }
}

