/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.support.oauth.events.OAuth20AccessTokenRequestEvent;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.device.InvalidOAuth20DeviceTokenException;
import org.apereo.cas.support.oauth.validator.token.device.ThrottledOAuth20DeviceUserCodeApprovalException;
import org.apereo.cas.support.oauth.validator.token.device.UnapprovedOAuth20DeviceUserCodeException;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AccessTokenResponseEncoder;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.OAuth20UnauthorizedScopeRequestException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="OAuth")
public class OAuth20AccessTokenEndpointController<T extends OAuth20ConfigurationContext>
extends BaseOAuth20Controller<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AccessTokenEndpointController.class);
    private static final Map<String, AccessTokenExceptionResponses> ACCESS_TOKEN_RESPONSE_EXCEPTIONS = Map.of(InvalidOAuth20DeviceTokenException.class.getName(), new AccessTokenExceptionResponses("access_denied", "Could not identify and extract device token request for device token"), UnapprovedOAuth20DeviceUserCodeException.class.getName(), new AccessTokenExceptionResponses("authorization_pending", "User code is not yet approved for the device token request"), ThrottledOAuth20DeviceUserCodeApprovalException.class.getName(), new AccessTokenExceptionResponses("slow_down", "Device user code approval is too quick and is throttled. Requests must slow down"), OAuth20UnauthorizedScopeRequestException.class.getName(), new AccessTokenExceptionResponses("invalid_scope", "Invalid or unauthorized scope"));
    private final AuditableExecution accessTokenGrantAuditableRequestExtractor;

    public OAuth20AccessTokenEndpointController(T oauthConfigurationContext, AuditableExecution accessTokenGrantAuditableRequestExtractor) {
        super(oauthConfigurationContext);
        this.accessTokenGrantAuditableRequestExtractor = accessTokenGrantAuditableRequestExtractor;
    }

    private static ModelAndView handleAccessTokenException(Throwable exception, HttpServletResponse response) {
        AccessTokenExceptionResponses data = ACCESS_TOKEN_RESPONSE_EXCEPTIONS.getOrDefault(exception.getClass().getName(), new AccessTokenExceptionResponses("invalid_grant", "Invalid or unauthorized grant"));
        LoggingUtils.error((Logger)LOGGER, (String)String.format("%s: %s", data.message(), exception.getMessage()), (Throwable)exception);
        return OAuth20Utils.writeError(response, data.code(), data.message());
    }

    @PostMapping(path={"/oauth2.0/accessToken", "/oauth2.0/token"}, produces={"application/json"})
    @Operation(summary="Handle OAuth access token request")
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JEEContext context = new JEEContext(request, response);
        try {
            if (!this.verifyAccessTokenRequest((WebContext)context)) {
                LOGGER.warn("Access token validation failed for request [{}]", (Object)context.getFullRequestURL());
                return OAuth20Utils.writeError(response, "invalid_grant");
            }
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return OAuth20Utils.writeError(response, "invalid_request");
        }
        try {
            AccessTokenRequestContext tokenRequestContext = this.examineAndExtractAccessTokenGrantRequest(request, response);
            this.logProtocolRequest(tokenRequestContext);
            LOGGER.debug("Creating access token for [{}]", (Object)tokenRequestContext);
            OAuth20TokenGeneratedResult generatedTokenResult = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getAccessTokenGenerator().generate(tokenRequestContext);
            LOGGER.debug("Access token generated result is: [{}]", (Object)generatedTokenResult);
            return this.generateAccessTokenResponse(tokenRequestContext, generatedTokenResult);
        }
        catch (Throwable e) {
            return OAuth20AccessTokenEndpointController.handleAccessTokenException(e, response);
        }
    }

    private void logProtocolRequest(AccessTokenRequestContext tokenRequestContext) {
        Ticket ticket;
        Authentication authn = tokenRequestContext.getAuthentication();
        if (authn == null && (ticket = tokenRequestContext.getTicketGrantingTicket()) instanceof AuthenticationAwareTicket) {
            AuthenticationAwareTicket aat = (AuthenticationAwareTicket)ticket;
            authn = aat.getAuthentication();
        }
        Objects.requireNonNull(authn, "No authentication is available to handle this request");
        Map<String, String> protocolContext = Map.of("Token", Optional.ofNullable(tokenRequestContext.getToken()).map(Ticket::getId).orElse("none"), "Device Code", StringUtils.defaultString((String)tokenRequestContext.getDeviceCode()), "Scopes", String.join((CharSequence)",", tokenRequestContext.getScopes()), "Registered Service", tokenRequestContext.getRegisteredService().getName(), "Service", tokenRequestContext.getService().getId(), "Principal", authn.getPrincipal().getId(), "Grant Type", tokenRequestContext.getGrantType().getType(), "Response Type", tokenRequestContext.getResponseType().getType());
        LoggingUtils.protocolMessage((String)"OAuth/OpenID Connect Token Request", protocolContext);
        this.configurationContext.getApplicationContext().publishEvent((ApplicationEvent)new OAuth20AccessTokenRequestEvent((Object)this, ClientInfoHolder.getClientInfo(), protocolContext));
    }

    @GetMapping(path={"/oauth2.0/accessToken", "/oauth2.0/token"})
    @Operation(summary="Handle OAuth access token request")
    public ModelAndView handleGetRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.handleRequest(request, response);
    }

    protected ModelAndView generateAccessTokenResponse(AccessTokenRequestContext tokenRequestContext, OAuth20TokenGeneratedResult result) {
        return new OAuth20AccessTokenResponseEncoder((OAuth20ConfigurationContext)this.getConfigurationContext()).encode(tokenRequestContext, result);
    }

    private AccessTokenRequestContext examineAndExtractAccessTokenGrantRequest(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        AuditableContext audit = AuditableContext.builder().httpRequest((Object)request).httpResponse((Object)response).build();
        AuditableExecutionResult accessResult = this.accessTokenGrantAuditableRequestExtractor.execute(audit);
        Optional execResult = accessResult.getExecutionResult();
        return (AccessTokenRequestContext)execResult.orElseThrow(() -> new UnsupportedOperationException("Access token request is not supported"));
    }

    private boolean verifyAccessTokenRequest(WebContext context) throws Throwable {
        List validators = (List)((OAuth20ConfigurationContext)this.getConfigurationContext()).getAccessTokenGrantRequestValidators().getObject();
        return validators.stream().filter(BeanSupplier::isNotProxy).filter(Unchecked.predicate(ext -> ext.supports(context))).findFirst().orElseThrow(() -> new UnsupportedOperationException("Access token request is not supported")).validate(context);
    }

    private record AccessTokenExceptionResponses(String code, String message) {
    }
}

