/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCode;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="OAuth")
public class OAuth20DeviceUserCodeApprovalEndpointController
extends BaseOAuth20Controller<OAuth20ConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20DeviceUserCodeApprovalEndpointController.class);
    public static final String PARAMETER_USER_CODE = "usercode";

    public OAuth20DeviceUserCodeApprovalEndpointController(OAuth20ConfigurationContext oAuthConfigurationContext) {
        super(oAuthConfigurationContext);
    }

    @GetMapping(path={"/oauth2.0/device"})
    @Operation(summary="Handle device code approval request")
    public ModelAndView handleGetRequest(HttpServletRequest request, HttpServletResponse response) {
        Map model = OAuth20DeviceUserCodeApprovalEndpointController.getApprovalModel("");
        return new ModelAndView("oauthDeviceCodeApprovalView", model);
    }

    @PostMapping(path={"/oauth2.0/device"})
    @Operation(summary="Handle device code approval request")
    public ModelAndView handlePostRequest(HttpServletRequest request, HttpServletResponse response) {
        String userCode = request.getParameter(PARAMETER_USER_CODE);
        ModelAndView codeNotfound = OAuth20DeviceUserCodeApprovalEndpointController.getModelAndViewForFailure("codenotfound");
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return codeNotfound;
        }
        try {
            OAuth20DeviceUserCodeFactory factory = (OAuth20DeviceUserCodeFactory)((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketFactory().get(OAuth20DeviceUserCode.class);
            String codeId = factory.normalizeUserCode(userCode);
            OAuth20DeviceUserCode deviceUserCode = (OAuth20DeviceUserCode)((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().getTicket(codeId, OAuth20DeviceUserCode.class);
            if (deviceUserCode.isUserCodeApproved()) {
                return OAuth20DeviceUserCodeApprovalEndpointController.getModelAndViewForFailure("codeapproved");
            }
            deviceUserCode.setUserCodeApproved(true);
            Ticket updatedDeviceUserCode = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().updateTicket((Ticket)deviceUserCode);
            return new ModelAndView("oauthDeviceCodeApprovedView", Map.of("code", updatedDeviceUserCode.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            return codeNotfound;
        }
    }

    private static ModelAndView getModelAndViewForFailure(String code) {
        return new ModelAndView("oauthDeviceCodeApprovalView", OAuth20DeviceUserCodeApprovalEndpointController.getApprovalModel(code));
    }

    private static Map getApprovalModel(String errorCode) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("prefix", "ODUC");
        if (StringUtils.isNotBlank((CharSequence)errorCode)) {
            map.put("error", errorCode);
        }
        return map;
    }
}

