/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.device;

import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenUtils;
import org.apereo.cas.util.function.FunctionUtils;

public class OAuth20DefaultDeviceTokenFactory
implements OAuth20DeviceTokenFactory {
    protected final UniqueTicketIdGenerator ticketIdGenerator;
    protected final ExpirationPolicyBuilder<OAuth20DeviceToken> expirationPolicyBuilder;
    protected final int userCodeLength;
    protected final ServicesManager servicesManager;

    public OAuth20DeviceToken createDeviceCode(Service service) throws Throwable {
        String codeId = this.ticketIdGenerator.getNewTicketId("ODT");
        ExpirationPolicy expirationPolicyToUse = OAuth20DeviceTokenUtils.determineExpirationPolicyForService(this.servicesManager, this.expirationPolicyBuilder, service);
        OAuth20DefaultDeviceToken token = new OAuth20DefaultDeviceToken(codeId, service, expirationPolicyToUse);
        FunctionUtils.doIfNotNull((Object)service, __ -> token.setTenantId(service.getTenant()));
        return token;
    }

    public Class<? extends Ticket> getTicketType() {
        return OAuth20DeviceToken.class;
    }

    @Generated
    public OAuth20DefaultDeviceTokenFactory(UniqueTicketIdGenerator ticketIdGenerator, ExpirationPolicyBuilder<OAuth20DeviceToken> expirationPolicyBuilder, int userCodeLength, ServicesManager servicesManager) {
        this.ticketIdGenerator = ticketIdGenerator;
        this.expirationPolicyBuilder = expirationPolicyBuilder;
        this.userCodeLength = userCodeLength;
        this.servicesManager = servicesManager;
    }

    @Generated
    public UniqueTicketIdGenerator getTicketIdGenerator() {
        return this.ticketIdGenerator;
    }

    @Generated
    public ExpirationPolicyBuilder<OAuth20DeviceToken> getExpirationPolicyBuilder() {
        return this.expirationPolicyBuilder;
    }
}

