/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.loader;

import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.loader.BaseConfigurationPropertiesLoader;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class GroovyConfigurationPropertiesLoader
extends BaseConfigurationPropertiesLoader {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyConfigurationPropertiesLoader.class);

    public PropertySource load(Resource resource, Environment environment, String name, CipherExecutor<String, String> configurationCipherExecutor) {
        LinkedHashMap properties = new LinkedHashMap();
        ConfigSlurper configSlurper = new ConfigSlurper();
        configSlurper.setClassLoader(ScriptingUtils.newGroovyClassLoader());
        List applicationProfiles = this.getApplicationProfiles(environment);
        applicationProfiles.forEach(Unchecked.consumer(profile -> {
            configSlurper.setEnvironment(profile);
            configSlurper.registerConditionalBlock("profiles", profile);
            Map bindings = CollectionUtils.wrap((String)"profile", (Object)profile, (String)"logger", (Object)LOGGER, (String)"env", System.getenv());
            configSlurper.setBinding(bindings);
            ConfigObject groovyConfig = configSlurper.parse(resource.getURL());
            Properties pp = groovyConfig.toProperties();
            LOGGER.debug("Found settings [{}] in Groovy file [{}]", pp.keySet(), (Object)resource);
            properties.putAll(pp);
        }));
        return this.finalizeProperties(name, this.decryptProperties(configurationCipherExecutor, properties));
    }

    public boolean supports(Resource resource) {
        String filename = StringUtils.defaultString((String)resource.getFilename()).toLowerCase(Locale.ENGLISH);
        return filename.endsWith(".groovy");
    }

    @Generated
    public GroovyConfigurationPropertiesLoader() {
    }
}

