/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.syncope.client.console.panels.AbstractSchemaDetailsPanel;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.ui.commons.Constants;
import org.apache.syncope.client.ui.commons.MIMETypesLoader;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxGridFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;

public class PlainSchemaDetails
extends AbstractSchemaDetailsPanel {
    private static final long serialVersionUID = 5378100729213456451L;
    @SpringBean
    protected MIMETypesLoader mimeTypesLoader;
    @SpringBean
    protected ImplementationRestClient implementationRestClient;
    protected final IModel<List<String>> validators = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return PlainSchemaDetails.this.implementationRestClient.list("ATTR_VALUE_VALIDATOR").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
        }
    };
    protected final IModel<List<String>> dropdownValueProviders = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return PlainSchemaDetails.this.implementationRestClient.list("DROPDOWN_VALUE_PROVIDER").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
        }
    };
    protected final PlainSchemaTO schemaTO;
    protected final AjaxDropDownChoicePanel<String> validator;
    protected final AjaxDropDownChoicePanel<AttrSchemaType> type;
    protected final AjaxTextFieldPanel conversionPattern;
    protected final WebMarkupContainer conversionParams;
    protected final WebMarkupContainer enumParams;
    protected final AjaxGridFieldPanel<String, String> enumValues;
    protected final AjaxDropDownChoicePanel<String> dropdownValueProvider;
    protected final WebMarkupContainer dropdownParams;
    protected final AjaxTextFieldPanel secretKey;
    protected final AjaxDropDownChoicePanel<CipherAlgorithm> cipherAlgorithm;
    protected final AjaxCheckBoxPanel transparentEncryption;
    protected final WebMarkupContainer encryptedParams;
    protected final AjaxTextFieldPanel mimeType;
    protected final WebMarkupContainer binaryParams;

    public PlainSchemaDetails(String id, final PlainSchemaTO schemaTO) {
        super(id, (SchemaTO)schemaTO);
        this.schemaTO = schemaTO;
        this.type = new AjaxDropDownChoicePanel("type", this.getString("type"), (IModel)new PropertyModel((Object)schemaTO, "type"));
        boolean isCreate = schemaTO == null || schemaTO.getKey() == null || schemaTO.getKey().isEmpty();
        this.type.setChoices(List.of(AttrSchemaType.values()));
        this.type.setEnabled(isCreate);
        this.type.addRequiredLabel();
        this.add(new Component[]{this.type});
        this.conversionPattern = new AjaxTextFieldPanel("conversionPattern", this.getString("conversionPattern"), (IModel)new PropertyModel((Object)schemaTO, "conversionPattern"));
        this.add(new Component[]{this.conversionPattern});
        this.conversionParams = new WebMarkupContainer("conversionParams");
        this.conversionParams.setOutputMarkupPlaceholderTag(true);
        this.conversionParams.add(new Component[]{this.conversionPattern});
        this.add(new Component[]{this.conversionParams});
        final WebMarkupContainer typeParams = new WebMarkupContainer("typeParams");
        typeParams.setOutputMarkupPlaceholderTag(true);
        this.enumValues = new AjaxGridFieldPanel("enumValues", "enumValues", (IModel)new PropertyModel((Object)schemaTO, "enumValues"), false);
        this.enumParams = new WebMarkupContainer("enumParams");
        this.enumParams.setOutputMarkupPlaceholderTag(true);
        this.enumParams.add(new Component[]{this.enumValues});
        typeParams.add(new Component[]{this.enumParams});
        this.dropdownValueProvider = new AjaxDropDownChoicePanel("dropdownValueProvider", this.getString("dropdownValueProvider"), (IModel)new PropertyModel((Object)schemaTO, "dropdownValueProvider"));
        this.dropdownValueProvider.setOutputMarkupId(true);
        ((DropDownChoice)this.dropdownValueProvider.getField()).setNullValid(true);
        this.dropdownValueProvider.setChoices((List)this.dropdownValueProviders.getObject());
        this.dropdownValueProvider.setRequired(true);
        this.dropdownParams = new WebMarkupContainer("dropdownParams");
        this.dropdownParams.setOutputMarkupPlaceholderTag(true);
        this.dropdownParams.add(new Component[]{this.dropdownValueProvider});
        typeParams.add(new Component[]{this.dropdownParams});
        this.secretKey = new AjaxTextFieldPanel("secretKey", this.getString("secretKey"), (IModel)new PropertyModel((Object)schemaTO, "secretKey"));
        this.cipherAlgorithm = new AjaxDropDownChoicePanel("cipherAlgorithm", this.getString("cipherAlgorithm"), (IModel)new PropertyModel((Object)schemaTO, "cipherAlgorithm"));
        this.cipherAlgorithm.setChoices(List.of(CipherAlgorithm.values()));
        this.transparentEncryption = new AjaxCheckBoxPanel("transparentEncryption", "transparentEncryption", (IModel)new Model<Boolean>(this){
            private static final long serialVersionUID = 5636572627689425575L;
            final /* synthetic */ PlainSchemaDetails this$0;
            {
                this.this$0 = this$0;
            }

            public Boolean getObject() {
                return "ENCRYPTED_DECODE_CONVERSION_PATTERN".equals(schemaTO.getConversionPattern());
            }

            public void setObject(Boolean object) {
                schemaTO.setConversionPattern(BooleanUtils.isTrue((Boolean)object) ? "ENCRYPTED_DECODE_CONVERSION_PATTERN" : null);
            }
        }, true);
        this.encryptedParams = new WebMarkupContainer("encryptedParams");
        this.encryptedParams.setOutputMarkupPlaceholderTag(true);
        this.encryptedParams.add(new Component[]{this.secretKey});
        this.encryptedParams.add(new Component[]{this.cipherAlgorithm});
        this.encryptedParams.add(new Component[]{this.transparentEncryption});
        typeParams.add(new Component[]{this.encryptedParams});
        this.mimeType = new AjaxTextFieldPanel("mimeType", this.getString("mimeType"), (IModel)new PropertyModel((Object)schemaTO, "mimeType"));
        this.binaryParams = new WebMarkupContainer("binaryParams");
        this.binaryParams.setOutputMarkupPlaceholderTag(true);
        this.binaryParams.add(new Component[]{this.mimeType});
        typeParams.add(new Component[]{this.binaryParams});
        this.add(new Component[]{typeParams});
        this.showHide();
        this.type.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior(this, "change"){
            private static final long serialVersionUID = -1107858522700306810L;
            final /* synthetic */ PlainSchemaDetails this$0;
            {
                this.this$0 = this$0;
                super(event);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                this.this$0.showHide();
                target.add(new Component[]{this.this$0.conversionParams});
                target.add(new Component[]{typeParams});
                target.add(new Component[]{this.this$0.dropdownValueProvider});
                target.add(new Component[]{this.this$0.validator});
            }
        }});
        this.validator = new AjaxDropDownChoicePanel("validator", this.getString("validator"), (IModel)new PropertyModel((Object)schemaTO, "validator"));
        this.validator.setOutputMarkupId(true);
        ((DropDownChoice)this.validator.getField()).setNullValid(true);
        this.validator.setChoices((List)this.validators.getObject());
        this.add(new Component[]{this.validator});
        AutoCompleteTextField<String> mandatoryCondition = new AutoCompleteTextField<String>("mandatoryCondition", (IModel)new PropertyModel((Object)schemaTO, "mandatoryCondition")){
            private static final long serialVersionUID = -2428903969518079100L;

            protected Iterator<String> getChoices(String input) {
                List<String> choices = new ArrayList();
                if (Strings.isEmpty((String)input)) {
                    choices = List.of();
                } else if ("true".startsWith(input.toLowerCase())) {
                    choices.add("true");
                } else if ("false".startsWith(input.toLowerCase())) {
                    choices.add("false");
                }
                return choices.iterator();
            }
        };
        mandatoryCondition.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        this.add(new Component[]{mandatoryCondition});
        this.add(new Component[]{Constants.getJEXLPopover((Component)this, (TooltipConfig.Placement)TooltipConfig.Placement.right)});
        this.add(new Component[]{new AjaxCheckBoxPanel("multivalue", this.getString("multivalue"), (IModel)new PropertyModel((Object)schemaTO, "multivalue"))});
        this.add(new Component[]{new AjaxCheckBoxPanel("readonly", this.getString("readonly"), (IModel)new PropertyModel((Object)schemaTO, "readonly"))});
        this.add(new Component[]{new AjaxCheckBoxPanel("uniqueConstraint", this.getString("uniqueConstraint"), (IModel)new PropertyModel((Object)schemaTO, "uniqueConstraint")).setEnabled(isCreate)});
    }

    private void showHide() {
        int typeOrdinal = -1;
        try {
            typeOrdinal = Integer.parseInt(this.type.getField().getValue());
        }
        catch (NumberFormatException e) {
            LOG.error("Invalid value found: {}", (Object)this.type.getField().getValue(), (Object)e);
        }
        if (AttrSchemaType.Long.ordinal() == typeOrdinal || AttrSchemaType.Double.ordinal() == typeOrdinal || AttrSchemaType.Date.ordinal() == typeOrdinal) {
            this.conversionParams.setVisible(true);
            this.enumParams.setVisible(false);
            this.enumValues.setModelObject(new HashMap());
            this.dropdownParams.setVisible(false);
            this.dropdownValueProvider.setModelObject(null);
            if (this.dropdownValueProvider.isRequired()) {
                this.dropdownValueProvider.removeRequiredLabel();
            }
            this.encryptedParams.setVisible(false);
            if (this.secretKey.isRequired()) {
                this.secretKey.removeRequiredLabel();
            }
            this.secretKey.setModelObject(null);
            if (this.cipherAlgorithm.isRequired()) {
                this.cipherAlgorithm.removeRequiredLabel();
            }
            this.cipherAlgorithm.setModelObject(null);
            this.binaryParams.setVisible(false);
            this.mimeType.setModelObject(null);
            this.mimeType.setChoices(null);
        } else if (AttrSchemaType.Enum.ordinal() == typeOrdinal) {
            this.conversionParams.setVisible(false);
            this.conversionPattern.setModelObject(null);
            this.enumParams.setVisible(true);
            this.enumValues.setModelObject(this.schemaTO.getEnumValues());
            this.dropdownParams.setVisible(false);
            this.dropdownValueProvider.setModelObject(null);
            if (this.dropdownValueProvider.isRequired()) {
                this.dropdownValueProvider.removeRequiredLabel();
            }
            this.encryptedParams.setVisible(false);
            if (this.secretKey.isRequired()) {
                this.secretKey.removeRequiredLabel();
            }
            this.secretKey.setModelObject(null);
            if (this.cipherAlgorithm.isRequired()) {
                this.cipherAlgorithm.removeRequiredLabel();
            }
            this.cipherAlgorithm.setModelObject(null);
            this.binaryParams.setVisible(false);
            this.mimeType.setModelObject(null);
            this.mimeType.setChoices(null);
        } else if (AttrSchemaType.Dropdown.ordinal() == typeOrdinal) {
            this.conversionParams.setVisible(false);
            this.conversionPattern.setModelObject(null);
            this.enumParams.setVisible(false);
            this.enumValues.setModelObject(this.schemaTO.getEnumValues());
            this.dropdownParams.setVisible(true);
            if (!this.dropdownValueProvider.isRequired()) {
                this.dropdownValueProvider.addRequiredLabel();
            }
            this.encryptedParams.setVisible(false);
            if (this.secretKey.isRequired()) {
                this.secretKey.removeRequiredLabel();
            }
            this.secretKey.setModelObject(null);
            if (this.cipherAlgorithm.isRequired()) {
                this.cipherAlgorithm.removeRequiredLabel();
            }
            this.cipherAlgorithm.setModelObject(null);
            this.binaryParams.setVisible(false);
            this.mimeType.setModelObject(null);
            this.mimeType.setChoices(null);
        } else if (AttrSchemaType.Encrypted.ordinal() == typeOrdinal) {
            this.conversionParams.setVisible(false);
            this.enumParams.setVisible(false);
            this.enumValues.setModelObject(new HashMap());
            this.dropdownParams.setVisible(false);
            this.dropdownValueProvider.setModelObject(null);
            if (this.dropdownValueProvider.isRequired()) {
                this.dropdownValueProvider.removeRequiredLabel();
            }
            this.encryptedParams.setVisible(true);
            if (!this.secretKey.isRequired()) {
                this.secretKey.addRequiredLabel();
            }
            if (this.cipherAlgorithm.isRequired()) {
                this.cipherAlgorithm.addRequiredLabel();
            }
            this.binaryParams.setVisible(false);
            this.mimeType.setModelObject(null);
            this.mimeType.setChoices(null);
        } else if (AttrSchemaType.Binary.ordinal() == typeOrdinal) {
            this.conversionParams.setVisible(false);
            this.conversionPattern.setModelObject(null);
            this.enumParams.setVisible(false);
            this.enumValues.setModelObject(new HashMap());
            this.dropdownParams.setVisible(false);
            this.dropdownValueProvider.setModelObject(null);
            if (this.dropdownValueProvider.isRequired()) {
                this.dropdownValueProvider.removeRequiredLabel();
            }
            this.encryptedParams.setVisible(false);
            if (this.secretKey.isRequired()) {
                this.secretKey.removeRequiredLabel();
            }
            this.secretKey.setModelObject(null);
            if (this.cipherAlgorithm.isRequired()) {
                this.cipherAlgorithm.removeRequiredLabel();
            }
            this.cipherAlgorithm.setModelObject(null);
            this.binaryParams.setVisible(true);
            this.mimeType.setChoices(this.mimeTypesLoader.getMimeTypes());
            this.schemaTO.setValidator("BinaryValidator");
        } else {
            this.conversionParams.setVisible(false);
            this.conversionPattern.setModelObject(null);
            this.enumParams.setVisible(false);
            this.enumValues.setModelObject(new HashMap());
            this.dropdownParams.setVisible(false);
            this.dropdownValueProvider.setModelObject(null);
            if (this.dropdownValueProvider.isRequired()) {
                this.dropdownValueProvider.removeRequiredLabel();
            }
            this.encryptedParams.setVisible(false);
            if (this.secretKey.isRequired()) {
                this.secretKey.removeRequiredLabel();
            }
            this.secretKey.setModelObject(null);
            if (this.cipherAlgorithm.isRequired()) {
                this.cipherAlgorithm.removeRequiredLabel();
            }
            this.cipherAlgorithm.setModelObject(null);
            this.binaryParams.setVisible(false);
            this.mimeType.setModelObject(null);
            this.mimeType.setChoices(null);
        }
        if (this.type.isEnabled() && AttrSchemaType.Binary.ordinal() != typeOrdinal) {
            this.schemaTO.setValidator(null);
        }
    }
}

