/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.AbstractFlatteningPersonAttributeDao;
import org.apereo.cas.authentication.attribute.SimplePersonAttributes;
import org.apereo.cas.authentication.attribute.SimpleUsernameAttributeProvider;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.authentication.principal.attribute.UsernameAttributeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDefaultAttributePersonAttributeDao
extends AbstractFlatteningPersonAttributeDao {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDefaultAttributePersonAttributeDao.class);
    private UsernameAttributeProvider usernameAttributeProvider = new SimpleUsernameAttributeProvider();

    public PersonAttributes getPerson(String uid, Set<PersonAttributes> resultPeople, PersonAttributeDaoFilter filter) {
        if (!this.isEnabled()) {
            return null;
        }
        Map<String, List<Object>> seed = this.toSeedMap(uid);
        Set people = this.getPeopleWithMultivaluedAttributes(seed, filter, resultPeople);
        PersonAttributes person = this.getSinglePerson(people);
        if (person == null) {
            return null;
        }
        if (person.getName() == null) {
            person = new SimplePersonAttributes(uid, person.getAttributes());
        }
        return person;
    }

    protected Map<String, List<Object>> toSeedMap(String username) {
        List<String> values = List.of(username);
        String usernameAttribute = this.usernameAttributeProvider.getUsernameAttribute();
        Map<String, List<Object>> seed = Map.of(usernameAttribute, values);
        LOGGER.debug("Created seed map [{}] for username [{}]", seed, (Object)username);
        return seed;
    }

    @Generated
    public UsernameAttributeProvider getUsernameAttributeProvider() {
        return this.usernameAttributeProvider;
    }

    @Generated
    public void setUsernameAttributeProvider(UsernameAttributeProvider usernameAttributeProvider) {
        this.usernameAttributeProvider = usernameAttributeProvider;
    }
}

