/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.springframework.beans.factory.DisposableBean;

public abstract class AbstractAuditTrailManager
implements AuditTrailManager,
DisposableBean {
    public static final long DEFAULT_MAX_AUDIT_RECORDS_TO_FETCH = 100L;
    protected boolean asynchronous;
    private final ExecutorService executorService = Executors.newVirtualThreadPerTaskExecutor();

    public void record(AuditActionContext audit) {
        if (this.asynchronous) {
            this.executorService.execute(() -> this.saveAuditRecord(audit));
        } else {
            this.saveAuditRecord(audit);
        }
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    protected abstract void saveAuditRecord(AuditActionContext var1);

    @Generated
    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    @Generated
    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    @Generated
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Generated
    protected AbstractAuditTrailManager() {
    }

    @Generated
    protected AbstractAuditTrailManager(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }
}

