/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ScopedRunner {
    private FacesContext context;
    private Map<String, Object> scopedVariables;
    private Map<String, Object> previousVariables = new HashMap<String, Object>();

    public ScopedRunner(FacesContext context) {
        this(context, new HashMap<String, Object>());
    }

    public ScopedRunner(FacesContext context, Map<String, Object> scopedVariables) {
        this.context = context;
        this.scopedVariables = scopedVariables;
    }

    public ScopedRunner with(String key, Object value) {
        this.scopedVariables.put(key, value);
        return this;
    }

    public void invoke(Runnable callback) {
        try {
            this.setNewScope();
            callback.run();
        }
        finally {
            this.restorePreviousScope();
        }
    }

    public void invokeThrowing(ThrowingRunnable callback) throws IOException {
        try {
            this.setNewScope();
            callback.run();
        }
        finally {
            this.restorePreviousScope();
        }
    }

    private void setNewScope() {
        this.previousVariables.clear();
        Map<String, Object> requestMap = this.context.getExternalContext().getRequestMap();
        for (Map.Entry<String, Object> entry : this.scopedVariables.entrySet()) {
            Object previousVariable = requestMap.put(entry.getKey(), entry.getValue());
            if (previousVariable == null) continue;
            this.previousVariables.put(entry.getKey(), previousVariable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorePreviousScope() {
        try {
            Map<String, Object> requestMap = this.context.getExternalContext().getRequestMap();
            for (Map.Entry<String, Object> entry : this.scopedVariables.entrySet()) {
                Object previousVariable = this.previousVariables.get(entry.getKey());
                if (previousVariable != null) {
                    requestMap.put(entry.getKey(), previousVariable);
                    continue;
                }
                requestMap.remove(entry.getKey());
            }
        }
        finally {
            this.previousVariables.clear();
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws IOException;
    }
}

