/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.select;

import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.form.select.IOptionRenderer;
import org.apache.wicket.extensions.markup.html.form.select.SelectOption;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.util.string.Strings;

public class SelectOptions<T>
extends RepeatingView {
    private static final long serialVersionUID = 1L;
    private boolean recreateChoices = false;
    private final IOptionRenderer<T> renderer;

    public SelectOptions(String id, IModel<? extends Collection<? extends T>> model, IOptionRenderer<T> renderer) {
        super(id, model);
        this.renderer = renderer;
        this.setRenderBodyOnly(true);
    }

    public SelectOptions(String id, Collection<? extends T> elements, IOptionRenderer<T> renderer) {
        this(id, (IModel<Collection<T>>)new CollectionModel(elements), renderer);
    }

    public SelectOptions<T> setRecreateChoices(boolean refresh) {
        this.recreateChoices = refresh;
        return this;
    }

    protected final void onPopulate() {
        if (this.size() == 0 || this.recreateChoices) {
            this.removeAll();
            Collection modelObject = (Collection)this.getDefaultModelObject();
            if (modelObject != null) {
                for (Object value : modelObject) {
                    WebMarkupContainer row = new WebMarkupContainer(this.newChildId());
                    row.setRenderBodyOnly(true);
                    this.add(new Component[]{row});
                    String text = this.renderer.getDisplayValue(value);
                    IModel<T> model = this.renderer.getModel(value);
                    row.add(new Component[]{this.newOption(text, model)});
                }
            }
        }
    }

    protected SelectOption<T> newOption(String text, IModel<T> model) {
        SimpleSelectOption<T> option = new SimpleSelectOption<T>("option", model, text);
        option.setEscapeModelStrings(this.getEscapeModelStrings());
        return option;
    }

    protected void onDetach() {
        this.renderer.detach();
        super.onDetach();
    }

    private static class SimpleSelectOption<V>
    extends SelectOption<V> {
        private static final long serialVersionUID = 1L;
        private final String text;

        public SimpleSelectOption(String id, IModel<V> model, String text) {
            super(id, model);
            this.text = text;
        }

        public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
            CharSequence escaped = this.text;
            if (this.getEscapeModelStrings()) {
                escaped = Strings.escapeMarkup((CharSequence)this.text);
            }
            this.replaceComponentTagBody(markupStream, openTag, escaped);
        }

        @Override
        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            tag.setType(XmlTag.TagType.OPEN);
        }
    }
}

