/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class ComponentStrings {
    private ComponentStrings() {
    }

    public static String toString(Component component, Throwable location) {
        Class<?> componentClass = component.getClass();
        String componentType = componentClass.getName();
        if (componentType.indexOf(36) >= 0) {
            componentType = componentClass.getSuperclass().getName();
        }
        componentType = componentType.substring(componentType.lastIndexOf(46) + 1);
        AppendingStringBuffer sb = new AppendingStringBuffer("The " + componentType.toLowerCase(Locale.ROOT) + " with id '" + component.getId() + "' that failed to render was " + location.getMessage() + "\n");
        String[] skippedElements = new String[]{"org.apache.wicket.MarkupContainer", "org.apache.wicket.Component", "org.apache.wicket.markup"};
        String[] breakingElements = new String[]{"org.apache.wicket.protocol.http.WicketServlet", "org.apache.wicket.protocol.http.WicketFilter", "java.lang.reflect"};
        StackTraceElement[] trace = location.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            String traceString = trace[i].toString();
            if (ComponentStrings.shouldSkip(traceString, skippedElements) || traceString.startsWith("sun.reflect.") && i > 1) continue;
            if (!traceString.contains("java.lang.reflect")) {
                sb.append("     at ");
                sb.append(traceString);
                sb.append("\n");
            }
            if (ComponentStrings.shouldSkip(traceString, breakingElements)) break;
        }
        sb.append("\n");
        return sb.toString();
    }

    private static boolean shouldSkip(String text, String[] filters) {
        for (String filter : filters) {
            if (!text.contains(filter)) continue;
            return true;
        }
        return false;
    }
}

