#! /bin/sh

name=gmp
version=5.0.2

djver1=`echo $version | sed -e 's:\.::2g'`
djver2=`echo $version | sed -e 's:\.::g'`
dname=$name-$djver1

rm -rf inst.djg
make install install-info prefix=`pwd`/inst.djg
make check >check.log 2>&1

mkdir -p inst.djg/manifest
mkdir -p inst.djg/gnu/$dname

touch inst.djg/manifest/$name${djver2}b.mft

cat >inst.djg/manifest/$name${djver2}b.ver <<E2
gmp${djver2}b.zip: GMP - GNU Multiple Precision Arithmetic Library (version $version binaries)
E2

cp -v authors COPYING* inst.djg/gnu/$dname/
cp -v news readme* inst.djg/gnu/$dname/
cp -v check.log inst.djg/gnu/$dname/

rm -f inst.djg/share/info/dir

info_sed_opt=
for file in $(cd inst.djg/share/info && ls -1b $name.info*); do
  nn=$(echo $file | sed -e 's/\.info\-\([^.]*\)$/.i\1/')
  sed -e 's/^'$name'\.info\-\([^:]*\):/'$name'\.i\1:/' inst.djg/share/info/$file >inst.djg/share/info/$file.new
  rm -f inst.djg/share/info/$file
  mv -f inst.djg/share/info/$file.new inst.djg/share/info/$nn
done

mkdir -p inst.djg/info
mv -v inst.djg/share/info/* inst.djg/info/

( cd inst.djg && find . -type f | sed -e 's:^\./::' | sort >manifest/$name${djver2}b.mft )
( cd inst.djg && cat manifest/$name${djver2}b.mft | zip -9@ ../$name${djver2}b.zip )
