/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <stdlib.h>
#include <string.h>

#include "libsupp.h"


error_t
libsupp_argz_create(char *const argv[], char **argz, size_t *argz_len)
{
  /*
   *  Make a '\0' separated argz vector from a ARGV vector,
   *  returning it via ARGZ, and the total length in ARGZ_LEN.
   *  If a memory allocation error occurs, ENOMEM is returned,
   *  otherwise 0.
   */

  *argz_len = 0;
  if (*argv == NULL)
    *argz = NULL;
  else
  {
    unsigned int argc, i;
    char *p;

    for (argc = 0; argv[argc]; argc++)
      *argz_len += (strlen(argv[argc]) + 1);
    *argz = malloc(*argz_len);
    if (*argz == NULL)
      return ENOMEM;

    for (p = *argz, i = 0; i < argc; i++, p++)
      p = stpcpy(p, argv[i]);
  }

  return 0;
}
