/* Copyright (C) 2009 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */

#ifndef __libsupp_h_
#define __libsupp_h_

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/version.h>  /*  gcc 4.3.0 no longer includes this by default.  */
#include <stdarg.h>

/* For GCC-4.4.X the definitions have chenged again ...                    */
/* This is however not surprising as we are messing here with internal     */
/* stuff of GCC.                                                           */
#if ((__GNUC__ == 4) && (__GNUC_MINOR__ >= 4)) || (__GNUC__ > 4)
# undef va_start
# undef va_end
# undef va_arg
# define va_start(ap, last_arg)   __builtin_va_start(ap, last_arg)
# define va_end(ap)               __builtin_va_end(ap)
# define va_arg(v, l)             __builtin_va_arg(v, l)
#endif

#include <stdio.h>
#include <stdlib.h>


/*
 *  Functions implemented in libsupp 1.0.
 */

#if __DJGPP_MINOR__ < 4
__extension__ typedef signed long long intmax_t;
__extension__ typedef unsigned long long uintmax_t;
__DJ_off_t
# undef  __DJ_off_t
# define __DJ_off_t
#else
# ifndef _OFF_T
__DJ_off_t
#  define _OFF_T
# endif
#endif


int            libsupp__doprnt(const char *_fmt, va_list _ap, FILE *_f);
int            libsupp_asnprintf(char **_sp, size_t _n, const char *_fmt, ...) __attribute__((format (__printf__, 3, 4)));
int            libsupp_asprintf(char **_sp, const char *_fmt, ...) __attribute__((format (__printf__, 2, 3)));
int            libsupp_cprintf(const char *_fmt, ...) __attribute__((format (__printf__, 1, 2)));
int            libsupp_fprintf(FILE *_f, const char *_fmt, ...) __attribute__((format (__printf__, 2, 3)));
int            libsupp_printf(const char *_fmt, ...) __attribute__((format (__printf__, 1, 2)));
int            libsupp_snprintf(char *_s, size_t _n, const char *_fmt, ...) __attribute__((format (__printf__, 3, 4)));
int            libsupp_sprintf(char *_s, const char *_fmt, ...) __attribute__((format (__printf__, 2, 3)));
int            libsupp_vasnprintf(char **_sp, size_t _n, const char *_fmt, va_list _ap) __attribute__((format (__printf__, 3, 0)));
int            libsupp_vasprintf(char **_sp, const char *_fmt, va_list _ap) __attribute__((format (__printf__, 2, 0)));
int            libsupp_vfprintf(FILE *_s, const char *_fmt, va_list _ap) __attribute__((format (__printf__, 2, 0)));
int            libsupp_vprintf(const char *_fmt, va_list _ap) __attribute__((format (__printf__, 1, 0)));
int            libsupp_vsnprintf(char *_s, size_t n, const char *_fmt, va_list _ap) __attribute__((format (__printf__, 3, 0)));
int            libsupp_vsprintf(char *_s, const char *_fmt, va_list _ap) __attribute__((format (__printf__, 2, 0)));


/*
 *  Functions implemented in libsupp 2.0.
 */

int            libsupp_fseeko(FILE *_stream, off_t _offset, int _mode);
off_t          libsupp_ftello(FILE *_stream);

int            libsupp___signbitf(float x) __attribute__((const));
int            libsupp___signbitd(double x) __attribute__((const));
int            libsupp___signbitld(long double x) __attribute__((const));


/*
 *  Functions implemented in libsupp 3.0.
 */

double         libsupp_strtod(const char *_s, char **_sret);
float          libsupp_strtof(const char *_s, char **_sret);
long double    libsupp_strtold(const char *_s, char **_sret);


#include <errno.h>

#ifndef _ERROR_T
typedef int error_t;
# define _ERROR_T
#endif

error_t        libsupp_argz_add(char **_argz, size_t *_argz_len, const char *_str);
error_t        libsupp_argz_add_sep(char **_argz, size_t *_argz_len, const char *_str, int _sep);
error_t        libsupp_argz_append(char **_argz, size_t *_argz_len, const char *_buf, size_t _buf_len);
size_t         libsupp_argz_count(const char *_argz, size_t _argz_len);
error_t        libsupp_argz_create(char *const _argv[], char **_argz, size_t *_argz_len);
error_t        libsupp_argz_create_sep(const char *_str, int _sep, char **_argz, size_t *_argz_len);
void           libsupp_argz_delete(char **_argz, size_t *_argz_len, char *_entry);
void           libsupp_argz_extract(const char *_argz, size_t _argz_len, char **_argv);
error_t        libsupp_argz_insert(char **_argz, size_t *_argz_len, char *_before, const char *_entry);
char          *libsupp_argz_next(const char *_argz, size_t _argz_len, const char *_entry);
error_t        libsupp_argz_replace(char **_argz, size_t *_argz_len, const char *_str, const char *_with, unsigned *_replace_count);
void           libsupp_argz_stringify(char *_argz, size_t _argz_len, int _sep);


/*
 *  Functions implemented in libsupp 4.0.
 */

char          *libsupp_strndup(const char *_str, size_t _n);
size_t         libsupp_strnlen(const char *_str, size_t _n);


/*
 *  Functions implemented in libsupp 5.0.
 */

#include <dirent.h>

#if __DJGPP_MINOR__ < 4

#define DT_REG      0x1
#define DT_BLK      0x2
#define DT_CHR      0x3
#define DT_DIR      0x4
#define DT_FIFO     0x5
#define DT_LABEL    0x6
#define DT_LNK      0x7
#define DT_UNKNOWN  0xf

#define DTTOIF(dt)  (((dt) == DT_UNKNOWN ? 0 : (dt) - 1) << 12)


# include <sys/types.h>

# undef  dirent
# define dirent     libsupp_dirent
struct dirent {
  char d_namlen;
  char d_name[256];
  mode_t d_type;
};

DIR           *libsupp_opendir_2_03(const char *_dir_name);
struct dirent *libsupp_readdir_2_03(DIR *_dirp);

int            libsupp_open_2_03(const char* _filename, int _oflag, ...);
int            libsupp_close_2_03(int _handle);
int            libsupp_fchdir_2_03(int _fd);
#else
DIR           *libsupp_opendir(const char *_dir_name);
struct dirent *libsupp_readdir(DIR *_dirp);
#endif
void           libsupp_rewinddir(DIR *_dirp);


/*
 *  Functions implemented in libsupp 5.1.
 */

int            libsupp_closedir(DIR *_dirp);


/*
 *  Functions implemented in libsupp 5.2.
 */

#include <sys/stat.h>

#if __DJGPP_MINOR__ < 4
int            libsupp_access_2_03(const char *_fn, int _flags);
int            libsupp___chdir_2_03(const char *_mydirname);
void           libsupp__fixpath_2_03(const char *_in, char *_out);
int            libsupp_stat_2_03(const char *_path, struct stat *_statbuf);
int            libsupp_symlink_2_03(const char *_source, const char *_dest);
#else
int            libsupp_access(const char *_fn, int _flags);
int            libsupp___chdir(const char *_mydirname);
void           libsupp__fixpath(const char *_in, char *_out);
char          *libsupp___canonicalize_path(const char *_in, char *_out, size_t _path_max);
int            libsupp_lstat(const char *_path, struct stat *_statbuf);
char          *libsupp_realpath(const char *_in, char *_out);
#endif


/*
 *  Functions implemented in libsupp 6.0.
 */

#include <time.h>

size_t         libsupp_strftime(char *_s, size_t _maxsize, const char *_format, const struct tm *_t);
void          *libsupp_memmem(const void *_haystack, size_t _haystack_len, const void *_needle, size_t _needle_len);

#include <wctype.h>

wint_t         libsupp_towlower(wint_t _c);

#ifndef USE_DJGPP_STRL_FCTNS
# include <stddef.h>

size_t         libsupp_strlcpy(char *_dst, const char *_src, size_t _sz);
size_t         libsupp_strlcat(char *_dst, const char *_src, size_t _sz);
#endif


/*
 *  Functions implemented in libsupp 6.1.
 */

#ifndef USE_DJGPP_MBTOWC_FCTNS
# include <wchar.h>

/*  Conversion state information.  */
typedef struct
{
  int __count;
  union
  {
    wint_t __wch;
    unsigned char __wchb[4];
  } __value;  /*  Value so far.  */
} libsupp_mbstate_t;

# undef  mbstate_t
# define mbstate_t  libsupp_mbstate_t

int            libsupp_mblen(const char *_s, size_t _n);
int            libsupp_mbsinit(const libsupp_mbstate_t *_ps);
size_t         libsupp_mbrtowc(wchar_t *_pwc, const char *_s, size_t _n, libsupp_mbstate_t *_ps);
int            libsupp_mbtowc(wchar_t *_pwc, const char *_s, size_t _n);
#endif


/*
 *  Functions implemented in libsupp 6.2.
 */
#if 0
/*
 *  None of them are supported by DJGPP...
 */
#ifndef SA_NOCLDSTOP
# define SA_NOCLDSTOP  1                /* Do not generate SIGCHLD when children stop */
#endif
#ifndef SA_RESTART
# define SA_RESTART    0x10000000       /* Restart syscall on signal return */
#endif
#ifndef SA_NODEFER
# define SA_NODEFER    0x40000000       /* Don't automatically block the signal when its handler is being executed  */
#endif
#ifndef SA_ONESHOT
# define SA_ONESHOT    SA_RESETHAND     /* Historical linux name */
#endif
#ifndef SA_NOMASK
# define SA_NOMASK     SA_NODEFER       /* Historical linux name */
#endif
#else
/*
 *  .. so define them to some sane default.
 */
#ifndef SA_NOCLDSTOP
# define SA_NOCLDSTOP  0  /* Do not generate SIGCHLD when children stop */
#endif
#ifndef SA_RESTART
# define SA_RESTART    0  /* Restart syscall on signal return */
#endif
#ifndef SA_NODEFER
# define SA_NODEFER    0  /* Don't automatically block the signal when its handler is being executed  */
#endif
#ifndef SA_RESETHAND
# define SA_RESETHAND  0
#endif
#ifndef SA_ONESHOT
# define SA_ONESHOT    SA_RESETHAND     /* Historical linux name */
#endif
#ifndef SA_NOMASK
# define SA_NOMASK     SA_NODEFER       /* Historical linux name */
#endif
#endif

#ifndef _O_TEMPORARY
# define _O_TEMPORARY  O_TEMPORARY
#endif


int            libsupp__doscan(FILE *_iop, const char *_fmt, va_list _argp);
int            libsupp_fscanf(FILE *_f, const char *_fmt, ...);
int            libsupp_scanf(const char *_fmt, ...);
int            libsupp_sscanf(const char *_str, const char *_fmt, ...);
int            libsupp_vfscanf(FILE *_iop, const char *_fmt, va_list _argp);
int            libsupp_vscanf(const char *_fmt, va_list _ap);
int            libsupp_vsscanf(const char *_str, const char *_fmt, va_list _ap);

double         libsupp_atof(const char *_ascii);
long double    libsupp__atold(const char *_ascii);

int            libsupp_strnicmp(const char *_s1, const char *_s2, size_t _n);

wint_t         libsupp_towupper(wint_t _c);


#include <fcntl.h>           /*  For the modes.  */
#if __DJGPP_MINOR__ >= 4
# include <sys/statvfs.h>    /*  For struct statvfs.  */
#endif

#if __DJGPP_MINOR__ < 4
int            libsupp_fclose_2_03(FILE *_f);
int            libsupp_fflush_2_03(FILE *_f);
int            libsupp__flsbuf_2_03(int _c, FILE *_f);
FILE          *libsupp_fopen_2_03(const char *_file, const char *_mode);
FILE          *libsupp_freopen_2_03(const char *_file, const char *_mode, FILE *_f);
int            libsupp_fseek_2_03(FILE *_f, long _offset, int _ptrname);
long           libsupp_ftell_2_03(FILE *_f);
void           libsupp_rewind_2_03(FILE *_f);
int            libsupp_select_2_03(int _nfds, fd_set *_readfds, fd_set *_writefds, fd_set *_exceptfds, struct timeval *_timeout);
int            libsupp_fsync_2_03(int _fd);
int            libsupp_ftruncate_2_03(int _fd, off_t _where);
int            libsupp__close_2_03(int _handle);
int            libsupp__write_2_03(int _handle, const void* _buffer, size_t _count);
int            libsupp_fcntl_2_03(int _fd, int _cmd, ...);
FILE          *libsupp_fdopen_2_03(int _fildes, const char *_mode);
int            libsupp_dup2_2_03(int _fd, int _newfd);
int            libsupp_dup_2_03(int _fd);
off_t          libsupp_lseek_2_03(int _handle, off_t _offset, int _whence);
ssize_t        libsupp_read_2_03(int _handle, void* _buffer, size_t _count);
ssize_t        libsupp_write_2_03(int _handle, const void* _buffer, size_t _count);
int            libsupp_fstat_2_03(int _handle, struct stat *_statbuf);
#else
int            libsupp_fclose(FILE *_f);
int            libsupp_fflush(FILE *_f);
int            libsupp__flsbuf(int _c, FILE *_f);
FILE          *libsupp_fopen(const char *_file, const char *_mode);
FILE          *libsupp_freopen(const char *_file, const char *_mode, FILE *_f);
int            libsupp_fseek(FILE *_f, long _offset, int _ptrname);
long           libsupp_ftell(FILE *_f);
void           libsupp_rewind(FILE *_f);
int            libsupp_select(int _nfds, fd_set *_readfds, fd_set *_writefds, fd_set *_exceptfds, struct timeval *_timeout);
int            libsupp_fsync(int _fd);
int            libsupp_ftruncate(int _fd, off_t _where);
offset_t       libsupp_llseek(int _handle, offset_t _offset, int _whence);
int            libsupp__close(int _handle);
ssize_t        libsupp__write(int _handle, const void* _buffer, size_t _count);
int            libsupp__write_fill_seek_gap(int _fd);
int            libsupp__write_int(int _fd, const char *_buffer, unsigned long long _write_count);
int            libsupp_fcntl(int _fd, int _cmd, ...);
int            libsupp_open(const char* _filename, int _oflag, ...);
FILE          *libsupp_fdopen(int _fildes, const char *_mode);
int            libsupp_fchmod(int _fd, mode_t _mode);
int            libsupp_fstat(int _handle, struct stat *_statbuf);
int            libsupp_stat(const char *_path, struct stat *_statbuf);
int            libsupp_fstatvfs(int _fd, struct statvfs *_outbuf);
int            libsupp_close(int _handle);
int            libsupp_dup2(int _fd, int _newfd);
int            libsupp_dup(int _fd);
off_t          libsupp_lseek(int _handle, off_t _offset, int _whence);
int            libsupp_pipe(int _fildes[2]);
ssize_t        libsupp_read(int _handle, void* _buffer, size_t _count);
ssize_t        libsupp_write(int _handle, const void* _buffer, size_t _count);
long long      libsupp_lfilelength(int _fhandle);
#endif

#ifdef HUGE_VALF
# undef  HUGE_VALF
# define HUGE_VALF libsupp___dj_huge_valf
extern float       libsupp___dj_huge_valf;
#endif

#ifdef HUGE_VALL
# undef  HUGE_VALL
# define HUGE_VALL libsupp___dj_huge_vall
extern long double libsupp___dj_huge_vall;
#endif

#ifdef NAN
# undef  NAN
# define NAN libsupp___dj_nan
extern float libsupp___dj_nan;
#endif


/*
 *  Functions implemented in libsupp 6.3.
 */
#ifndef EILSEQ
# if (defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L) || !defined(__STRICT_ANSI__)
   /*  Value from 2.04 errno.h  */
#  define EILSEQ       41
# endif /* (__STDC_VERSION__ >= 199901L) || !__STRICT_ANSI__ */
#endif


#include <unistd.h>

int            libsupp_setegid(gid_t _gid);
int            libsupp_seteuid(uid_t _uid);

/*---------------------------------------------------------------------------*/


/*
 *  Make them visible.
 */

#undef  _doprnt
#define _doprnt                     libsupp__doprnt
#undef  asnprintf
#define asnprintf                   libsupp_asnprintf
#undef  asprintf
#define asprintf                    libsupp_asprintf
#undef  cprintf
#define cprintf                     libsupp_cprintf
#undef  fprintf
#define fprintf                     libsupp_fprintf
#undef  printf
#define printf                      libsupp_printf
#undef  snprintf
#define snprintf                    libsupp_snprintf
#undef  sprintf
#define sprintf                     libsupp_sprintf
#undef  vasnprintf
#define vasnprintf                  libsupp_vasnprintf
#undef  vasprintf
#define vasprintf                   libsupp_vasprintf
#undef  vfprintf
#define vfprintf                    libsupp_vfprintf
#undef  vprintf
#define vprintf                     libsupp_vprintf
#undef  vsnprintf
#define vsnprintf                   libsupp_vsnprintf
#undef  vsprintf
#define vsprintf                    libsupp_vsprintf

#undef  fseeko
#define fseeko                      libsupp_fseeko
#undef  ftello
#define ftello                      libsupp_ftello

#undef  __signbitd
#define __signbitd                  libsupp___signbitd
#undef  __signbitf
#define __signbitf                  libsupp___signbitf
#undef  __signbitld
#define __signbitld                 libsupp___signbitld

#ifndef signbit
#define signbit(x)   (__extension__ ({__typeof__(x) __x = (x); \
                                      (sizeof(__x) == sizeof(float)) ? __signbitf(__x) :  \
                                      (sizeof(__x) == sizeof(double)) ? __signbitd(__x) : \
                                      __signbitld(__x); \
                                     }))
#endif /* !signbit */

#undef  strtod
#define strtod                      libsupp_strtod
#undef  strtof
#define strtof                      libsupp_strtof
#undef  strtold
#define strtold                     libsupp_strtold
#undef  _strtold
#define _strtold                    libsupp_strtold

#undef  argz_add
#define argz_add                    libsupp_argz_add
#undef  argz_add_sep
#define argz_add_sep                libsupp_argz_add_sep
#undef  argz_append
#define argz_append                 libsupp_argz_append
#undef  argz_count
#define argz_count                  libsupp_argz_count
#undef  argz_create
#define argz_create                 libsupp_argz_create
#undef  argz_create_sep
#define argz_create_sep             libsupp_argz_create_sep
#undef  argz_delete
#define argz_delete                 libsupp_argz_delete
#undef  argz_extract
#define argz_extract                libsupp_argz_extract
#undef  argz_insert
#define argz_insert                 libsupp_argz_insert
#undef  argz_next
#define argz_next                   libsupp_argz_next
#undef  argz_replace
#define argz_replace                libsupp_argz_replace
#undef  argz_stringify
#define argz_stringify              libsupp_argz_stringify

#undef  strndup
#define strndup                     libsupp_strndup
#undef  strnlen
#define strnlen                     libsupp_strnlen

#if __DJGPP_MINOR__ < 4
# undef  opendir
# define opendir                    libsupp_opendir_2_03
# undef  readdir
# define readdir                    libsupp_readdir_2_03
# undef  open
# define open                       libsupp_open_2_03
# undef  close
# define close                      libsupp_close_2_03
# undef  fchdir
# define fchdir                     libsupp_fchdir_2_03
#else
# undef  opendir
# define opendir                    libsupp_opendir
# undef  readdir
# define readdir                    libsupp_readdir
# undef  close
# define close                      libsupp_close
#endif
#undef  rewinddir
#define rewinddir                   libsupp_rewinddir

#undef  closedir
#define closedir                    libsupp_closedir

#if __DJGPP_MINOR__ < 4
# undef  access
# define access                     libsupp_access_2_03
# undef  chdir
# define chdir                      libsupp___chdir_2_03
# undef  __chdir
# define __chdir                    libsupp___chdir_2_03
# undef  _fixpath
# define _fixpath                   libsupp__fixpath_2_03
# undef  stat
# define stat(file, statbuf)        libsupp_stat_2_03((file), (statbuf))  /*  Replace the function name and not the struct name.  */
# undef  symlink
# define symlink                    libsupp_symlink_2_03
# undef  access
# define access                     libsupp_access_2_03
#else
# undef  access
# define access                     libsupp_access
# undef  chdir
# define chdir                      libsupp___chdir
# undef  __chdir
# define __chdir                    libsupp___chdir
# undef  _fixpath
# define _fixpath                   libsupp__fixpath
# undef  __canonicalize_path
# define __canonicalize_path        libsupp___canonicalize_path
# undef  lstat
# define lstat                      libsupp_lstat
# undef  realpath
# define realpath                   libsupp_realpath
#endif

#ifndef USE_DJGPP_STRLCPY
# undef  strlcpy
# define strlcpy                    libsupp_strlcpy
# undef  strlcat
# define strlcat                    libsupp_strlcat
#endif
#undef  memmem
#define memmem                      libsupp_memmem
#undef  strftime
#define strftime                    libsupp_strftime
#undef  towlower
#define towlower                    libsupp_towlower

#ifndef USE_DJGPP_MBTOWC_FCTNS
# undef  mblen
# define mblen                      libsupp_mblen
# undef  mbrtowc
# define mbrtowc                    libsupp_mbrtowc
# undef  mbtowc
# define mbtowc                     libsupp_mbtowc
# undef  mbsinit
# define mbsinit                    libsupp_mbsinit
#endif

#undef  _doscan
#define _doscan                     libsupp__doscan
#undef  fscanf
#define fscanf                      libsupp_fscanf
#undef  scanf
#define scanf                       libsupp_scanf
#undef  sscanf
#define sscanf                      libsupp_sscanf
#undef  vfscanf
#define vfscanf                     libsupp_vfscanf
#undef  vscanf
#define vscanf                      libsupp_vscanf
#undef  vsscanf
#define vsscanf                     libsupp_vsscanf
#undef  atof
#define atof                        libsupp_atof
#undef  _atold
#define _atold                      libsupp__atold
#undef  strnicmp
#define strnicmp                    libsupp_strnicmp

#if __DJGPP_MINOR__ < 4
# undef  fclose
# define fclose                     libsupp_fclose_2_03
# undef  fflush
# define fflush                     libsupp_fflush_2_03
# undef  _flsbuf
# define _flsbuf                    libsupp__flsbuf_2_03
# undef  fopen
# define fopen                      libsupp_fopen_2_03
# undef  freopen
# define freopen                    libsupp_freopen_2_03
# undef  rewind
# define rewind                     libsupp_rewind_2_03
# undef  ftell
# define ftell                      libsupp_ftell_2_03
# undef  select
# define select                     libsupp_select_2_03
# undef  fsync
# define fsync                      libsupp_fsync_2_03
# undef  ftruncate
# define ftruncate                  libsupp_ftruncate_2_03
# undef  _close
# define _close                     libsupp__close_2_03
# undef  _write
# define _write                     libsupp__write_2_03
# undef  fcntl
# define fcntl                      libsupp_fcntl_2_03
# undef  fdopen
# define fdopen                     libsupp_fdopen_2_03
# undef  dup2
# define dup2                       libsupp_dup2_2_03
# undef  dup
# define dup                        libsupp_dup_2_03
# undef  lseek
# define lseek                      libsupp_lseek_2_03
# undef  read
# define read                       libsupp_read_2_03
# undef  write
# define write                      libsupp_write_2_03
# undef  fstat
# define fstat                      libsupp_fstat_2_03
#else
# undef  fclose
# define fclose                     libsupp_fclose
# undef  fflush
# define fflush                     libsupp_fflush
# undef  _flsbuf
# define _flsbuf                    libsupp__flsbuf
# undef  fopen
# define fopen                      libsupp_fopen
# undef  freopen
# define freopen                    libsupp_freopen
# undef  fseek
# define fseek                      libsupp_fseek
# undef  ftell
# define ftell                      libsupp_ftell
# undef  rewind
# define rewind                     libsupp_rewind
# undef  select
# define select                     libsupp_select
# undef  fsync
# define fsync                      libsupp_fsync
# undef  ftruncate
# define ftruncate                  libsupp_ftruncate
# undef  llseek
# define llseek                     libsupp_llseek
# undef  _close
# define _close                     libsupp__close
# undef  _write
# define _write                     libsupp__write
# undef  _write_fill_seek_gap
# define _write_fill_seek_gap       libsupp__write_fill_seek_gap
# undef  _write_int
# define _write_int                 libsupp__write_int
# undef  fcntl
# define fcntl                      libsupp_fcntl
# undef  open
# define open                       libsupp_open
# undef  fdopen
# define fdopen                     libsupp_fdopen
# undef  fchmod
# define fchmod                     libsupp_fchmod
# undef  fstat
# define fstat                      libsupp_fstat
# undef  stat
# define stat(path, statbuf)        libsupp_stat((path), (statbuf))  /*  Replace the function name and not the struct name.  */
# undef  fstatvfs
# define fstatvfs                   libsupp_fstatvfs
# undef  close
# define close                      libsupp_close
# undef  dup2
# define dup2                       libsupp_dup2
# undef  dup
# define dup                        libsupp_dup
# undef  lseek
# define lseek                      libsupp_lseek
# undef  pipe
# define pipe                       libsupp_pipe
# undef  read
# define read                       libsupp_read
# undef  write
# define write                      libsupp_write
# undef  lfilelength
# define lfilelength                libsupp_lfilelength
#endif

#undef  towupper
#define towupper                    libsupp_towupper

#undef  setegid
#define setegid                     libsupp_setegid
#undef  seteuid
#define seteuid                     libsupp_seteuid


#ifdef __cplusplus
}
#endif

#endif /* !__libsupp_h_ */
