/* Copyright (C) 2009 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1999 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <unistd.h>
#include <io.h>

#include "../include/libc/fd_props.h"
#include "libsupp.h"

int   libsupp_ftruncate_2_03(int _fd, off_t _where);
off_t libsupp_lseek_2_03(int _handle, off_t _offset, int _whence);
int   libsupp__write_2_03(int _handle, const void* _buffer, size_t _count);


int
libsupp_ftruncate_2_03(int fd, off_t where)
{
  off_t here;
  int retval = 0;

  /* Directory? If so, fail. */
  if (libsupp___get_fd_flags(fd) & FILE_DESC_DIRECTORY)
  {
    errno = EINVAL;
    return -1;
  }

  here = libsupp_lseek_2_03(fd, 0, SEEK_CUR);
  if (here == -1)
    return -1;
  if (libsupp_lseek_2_03(fd, where, SEEK_SET) == -1)
    return -1;
  if (libsupp__write_2_03(fd, 0, 0) < 0)
    retval = -1;
  libsupp_lseek_2_03(fd, here, SEEK_SET);
  return retval;
}
