/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <stdlib.h>
#include <string.h>

#include "libsupp.h"

#define EOS '\0'


error_t
libsupp_argz_create_sep(const char *str, int sep, char **argz, size_t *argz_len)
{
  /*
   *  Make a '\0' separated argz vector from a SEP separated list in
   *  STR, returning it via ARGZ, and the total length in ARGZ_LEN.
   *  If a memory allocation error occurs, ENOMEM is returned,
   *  otherwise 0.
   */

  if (!str || str[0] == EOS)
  {
    *argz_len = 0;
    *argz= NULL;
  }
  else
  {
    size_t i;

    *argz_len = strlen(str) + 1;
    *argz = malloc(*argz_len);
    if (*argz == NULL)
      return ENOMEM;

    for (i = 0; i < *argz_len; i++)
      (*argz)[i] = (str[i] == sep) ? EOS : str[i];
  }

  return 0;
}
