/* Copyright (C) 2009 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <string.h>
#include <stdlib.h>

#include "libsupp.h"


char *
libsupp_strndup(const char *str, size_t n)
{
  char *copy;
  size_t str_len;


  if (str == NULL)
    return NULL;

  str_len = strlen(str);
  if (str_len > n)
    str_len = n;

  copy = malloc(str_len + 1);
  if (copy == NULL)
    return NULL;
  memcpy(copy, str, str_len);
  copy[str_len] = '\0';

  return copy;
}
