/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.pe;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import net.charabia.jsmoothgen.pe.PEFile;

public class PESection
implements Cloneable {
    byte[] ANSI_Name;
    long VirtualSize;
    long VirtualAddress;
    long SizeOfRawData;
    long PointerToRawData;
    long PointerToRelocations;
    long PointerToLinenumbers;
    int NumberOfRelocations;
    int NumberOfLinenumbers;
    long Characteristics;
    private long m_baseoffset;
    private PEFile m_pe;

    public PESection(PEFile pef, long baseoffset) {
        this.m_pe = pef;
        this.m_baseoffset = baseoffset;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getName() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 8; ++i) {
            buffer.append((char)this.ANSI_Name[i]);
        }
        return buffer.toString();
    }

    public void read() throws IOException {
        FileChannel ch = this.m_pe.getChannel();
        ByteBuffer head = ByteBuffer.allocate(40);
        head.order(ByteOrder.LITTLE_ENDIAN);
        ch.position(this.m_baseoffset);
        ch.read(head);
        head.position(0);
        this.ANSI_Name = new byte[8];
        for (int i = 0; i < 8; ++i) {
            this.ANSI_Name[i] = head.get();
        }
        this.VirtualSize = head.getInt();
        this.VirtualAddress = head.getInt();
        this.SizeOfRawData = head.getInt();
        this.PointerToRawData = head.getInt();
        this.PointerToRelocations = head.getInt();
        this.PointerToLinenumbers = head.getInt();
        this.NumberOfRelocations = head.getShort();
        this.NumberOfLinenumbers = head.getShort();
        this.Characteristics = head.getInt();
    }

    public void dump(PrintStream out) {
        out.println("SECTION:");
        out.print("  Name= ");
        for (int i = 0; i < 8; ++i) {
            out.print((char)this.ANSI_Name[i]);
        }
        out.println("");
        out.println("  VirtualSize= " + this.VirtualSize + "  // \tThe size of the section when it is mapped to memory. Must be a multiple of 4096. (8)(DWORD)");
        out.println("  VirtualAddress= " + this.VirtualAddress + "   // \tAn rva to where it should be mapped in memory. (12)(DWORD)");
        out.println("  SizeOfRawData= " + this.SizeOfRawData + "   // \tThe size of the section in the PE file. Must be a multiple of 512 (16)(DWORD)");
        out.println("  PointerToRawData= " + this.PointerToRawData + "   // \tA file based offset which points to the location of this sections data (20)(DWORD)");
        out.println("  PointerToRelocations= " + this.PointerToRelocations + "   // \tIn EXE's this field is meaningless, and is set 0 (24)(DWORD)");
        out.println("  PointerToLinenumbers= " + this.PointerToLinenumbers + "   // \tThis is the file-based offset of the line number table. This field is only used for debug purposes, and is usualy set to 0 (28)(DWORD)");
        out.println("  NumberOfRelocations= " + this.NumberOfRelocations + "   // \tIn EXE's this field is meaningless, and is set 0 (32)(WORD)");
        out.println("  NumberOfLinenumbers= " + this.NumberOfLinenumbers + "   // \tThe number of line numbers in the line number table for this section. This field is only used for debug purposes, and is usualy set to 0 (34)(WORD)");
        out.println("  Characteristics= " + this.Characteristics + "   // \tThe kind of data stored in this section ie. Code, Data, Import data, Relocation data (36)(DWORD)");
    }

    public ByteBuffer get() {
        ByteBuffer head = ByteBuffer.allocate(40);
        head.order(ByteOrder.LITTLE_ENDIAN);
        head.position(0);
        for (int i = 0; i < 8; ++i) {
            head.put(this.ANSI_Name[i]);
        }
        head.putInt((int)this.VirtualSize);
        head.putInt((int)this.VirtualAddress);
        head.putInt((int)this.SizeOfRawData);
        head.putInt((int)this.PointerToRawData);
        head.putInt((int)this.PointerToRelocations);
        head.putInt((int)this.PointerToLinenumbers);
        head.putShort((short)this.NumberOfRelocations);
        head.putShort((short)this.NumberOfLinenumbers);
        head.putInt((int)this.Characteristics);
        head.position(0);
        return head;
    }
}

