/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.codegen.eclipse.ui;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class WSDLJavaAdvanceDialog
extends Dialog {
    private Button tmpCheckBox;
    private HashMap advanceOptions;
    private boolean isEditAdvanceOptions = false;
    private Combo wsdlVersionCombo;
    private Button packageRemoveButton;
    private Table packageNameList;
    private Button packageAddButton;
    private Text addNewExcludePackageName;

    protected WSDLJavaAdvanceDialog(Shell shell, HashMap advanceOptions) {
        super(shell);
        this.isEditAdvanceOptions = advanceOptions != null;
        this.advanceOptions = this.isEditAdvanceOptions ? (HashMap)advanceOptions.clone() : new HashMap();
    }

    private Button addCheckBox(Composite container, final Button tmpCheckBox, String caption, final String parameterType) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        tmpCheckBox.setLayoutData((Object)gd);
        tmpCheckBox.setText(caption);
        if (this.isEditAdvanceOptions) {
            tmpCheckBox.setSelection(this.advanceOptions.containsKey(parameterType));
        }
        tmpCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSDLJavaAdvanceDialog.this.setCheckBoxState(parameterType, tmpCheckBox.getSelection());
            }
        });
        return tmpCheckBox;
    }

    private Text addTextBox(Composite container, Label lblCaption, final Text tmpTextBox, String caption, final String parameterType, boolean isBrowseFolder) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 200;
        lblCaption.setLayoutData((Object)gd);
        lblCaption.setText(caption);
        gd = new GridData(768);
        gd.horizontalSpan = isBrowseFolder ? 1 : 2;
        tmpTextBox.setLayoutData((Object)gd);
        if (this.isEditAdvanceOptions && this.advanceOptions.containsKey(parameterType)) {
            tmpTextBox.setText(((String[])this.advanceOptions.get(parameterType))[0]);
        }
        tmpTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSDLJavaAdvanceDialog.this.setTextBoxValue(parameterType, tmpTextBox.getText());
            }
        });
        if (isBrowseFolder) {
            Button browse = new Button(container, 0);
            browse.setText("Browse");
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dialog = new DirectoryDialog(WSDLJavaAdvanceDialog.this.getShell());
                    String returnString = dialog.open();
                    if (returnString != null) {
                        tmpTextBox.setText(returnString);
                    }
                }
            });
        }
        return tmpTextBox;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        this.addTextBox(container, new Label(container, 0), new Text(container, 2048), "Specify a repository against which code is generated.", "r", true);
        this.addTextBox(container, new Label(container, 0), new Text(container, 2048), "Specify a directory path for generated source", "S", true);
        this.addTextBox(container, new Label(container, 0), new Text(container, 2048), "Specify a directory path for generated resources", "R", true);
        this.addTextBox(container, new Label(container, 0), new Text(container, 2048), "Proxy host address if you are behind a firewall", "http-proxy-host", false);
        this.addTextBox(container, new Label(container, 0), new Text(container, 2048), "Proxy port address if you are behind a firewall", "http-proxy-port", false);
        this.addTextBox(container, new Label(container, 0), new Text(container, 2048), "Skelton interface name", "sin", false);
        this.addTextBox(container, new Label(container, 0), new Text(container, 2048), "Skelton class name", "scn", false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        Label fillLabel = new Label(container, 258);
        fillLabel.setLayoutData((Object)gd);
        this.tmpCheckBox = new Button(container, 32);
        this.addCheckBox(container, this.tmpCheckBox, "Unpacks the databinding classes", "u");
        this.tmpCheckBox = new Button(container, 32);
        this.addCheckBox(container, this.tmpCheckBox, "Flattens the generated files", "f");
        this.tmpCheckBox = new Button(container, 32);
        this.addCheckBox(container, this.tmpCheckBox, "Switch on un-wrapping", "uw");
        this.tmpCheckBox = new Button(container, 32);
        this.addCheckBox(container, this.tmpCheckBox, "Generate code for all ports", "ap");
        this.tmpCheckBox = new Button(container, 32);
        this.addCheckBox(container, this.tmpCheckBox, "Overwrite the existing classes", "or");
        this.tmpCheckBox = new Button(container, 32);
        this.addCheckBox(container, this.tmpCheckBox, "Generate Axis 1.x backword compatible code", "b");
        this.tmpCheckBox = new Button(container, 32);
        this.addCheckBox(container, this.tmpCheckBox, "Suppress namespace prefixes (Optimzation that reduces size of soap request/response)", "sp");
        this.tmpCheckBox = new Button(container, 32);
        this.addCheckBox(container, this.tmpCheckBox, "Dont generate the build.xml in the output directory", "noBuildXML");
        this.tmpCheckBox = new Button(container, 32);
        this.addCheckBox(container, this.tmpCheckBox, "Dont generate WSDLs in the resources directory", "noWSDL");
        this.tmpCheckBox = new Button(container, 32);
        this.addCheckBox(container, this.tmpCheckBox, "Dont generate a MessageReceiver in the generated sources", "noMessageReceiver");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        fillLabel = new Label(container, 258);
        fillLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 400;
        Label fillLabel1 = new Label(container, 0);
        fillLabel1.setLayoutData((Object)gd);
        fillLabel1.setText("WSDL version");
        gd = new GridData(768);
        this.wsdlVersionCombo = new Combo(container, 2060);
        this.wsdlVersionCombo.setLayoutData((Object)gd);
        this.fillWSDLVersionCombo();
        String key = "wv";
        if (this.isEditAdvanceOptions && this.advanceOptions.containsKey(key)) {
            this.wsdlVersionCombo.select(this.wsdlVersionCombo.indexOf(((String[])this.advanceOptions.get(key))[0]));
        }
        this.wsdlVersionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSDLJavaAdvanceDialog.this.handleWsdlVersionComboSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        fillLabel = new Label(container, 258);
        fillLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        Label labelPackageAddCaption = new Label(container, 0);
        labelPackageAddCaption.setLayoutData((Object)gd);
        labelPackageAddCaption.setText("Excludes Packages");
        this.addNewExcludePackageName = new Text(container, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.addNewExcludePackageName.setLayoutData((Object)gd);
        this.addNewExcludePackageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSDLJavaAdvanceDialog.this.handleNewPackageNameChange();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.packageAddButton = new Button(container, 0);
        this.packageAddButton.setText("Add");
        this.packageAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSDLJavaAdvanceDialog.this.addPackageName();
            }
        });
        this.packageAddButton.setLayoutData((Object)gd);
        this.packageNameList = new Table(container, 66308);
        this.packageNameList.setLinesVisible(true);
        this.packageNameList.setHeaderVisible(true);
        this.packageNameList.setLayoutData((Object)gd);
        TableColumn column = new TableColumn(this.packageNameList, 0);
        column.setWidth(500);
        column.setText("Excluded packages");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.heightHint = 80;
        this.packageNameList.setLayoutData((Object)gd);
        this.packageNameList.setVisible(false);
        if (this.isEditAdvanceOptions) {
            this.updateExcludePackageList();
        }
        this.packageNameList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSDLJavaAdvanceDialog.this.handlePackageNameListClick();
            }
        });
        this.packageNameList.redraw();
        this.packageNameList.setVisible(true);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Label fillLabel4 = new Label(container, 0);
        fillLabel4.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.packageRemoveButton = new Button(container, 0);
        this.packageRemoveButton.setText("Remove");
        this.packageRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSDLJavaAdvanceDialog.this.removePackageName();
            }
        });
        this.packageRemoveButton.setLayoutData((Object)gd);
        this.handlePackageNameListClick();
        this.handleNewPackageNameChange();
        return super.createDialogArea(parent);
    }

    private void handlePackageNameListClick() {
        this.packageRemoveButton.setEnabled(this.packageNameList.getSelectionCount() > 0);
    }

    private void removePackageName() {
        if (this.packageNameList.getSelectionIndex() != -1) {
            String type = "ep";
            String[] commaSeperatedPackageList = (String[])this.advanceOptions.get(type);
            String[] packageList = commaSeperatedPackageList[0].split(",");
            Object newList = "";
            int selectedIndex = this.packageNameList.getSelectionIndex();
            String toRemove = this.packageNameList.getItem(selectedIndex).getText();
            for (String s : packageList) {
                if (s.equalsIgnoreCase(toRemove)) continue;
                newList = ((String)newList).equalsIgnoreCase("") ? s : (String)newList + "," + s;
            }
            if (((String)newList).equalsIgnoreCase("")) {
                this.advanceOptions.remove(type);
            } else {
                this.advanceOptions.put(type, new String[]{newList});
            }
            this.packageNameList.remove(selectedIndex);
            if (selectedIndex >= this.packageNameList.getItemCount()) {
                --selectedIndex;
            }
            this.packageNameList.select(selectedIndex);
        }
        this.packageNameList.redraw();
        this.handlePackageNameListClick();
    }

    private void addPackageName() {
        Object newList;
        String type = "ep";
        if (this.packageNameList.getItemCount() > 0) {
            String[] commaSeperatedPackageList = (String[])this.advanceOptions.get(type);
            newList = commaSeperatedPackageList[0] + "," + this.addNewExcludePackageName.getText();
        } else {
            newList = this.addNewExcludePackageName.getText();
        }
        this.advanceOptions.put(type, new String[]{newList});
        this.addTableItem(this.addNewExcludePackageName.getText());
        this.addNewExcludePackageName.setText("");
        this.handleNewPackageNameChange();
    }

    private void updateExcludePackageList() {
        this.packageNameList.clearAll();
        String type = "ep";
        if (this.advanceOptions.containsKey(type)) {
            String[] packageList;
            String[] commaSeperatedPackageList = (String[])this.advanceOptions.get(type);
            for (String string : packageList = commaSeperatedPackageList[0].split(",")) {
                this.addTableItem(string);
            }
        }
    }

    private void addTableItem(String itemText) {
        TableItem item = new TableItem(this.packageNameList, 0);
        item.setText(itemText);
    }

    private void handleNewPackageNameChange() {
        Pattern p = Pattern.compile("^[a-zA-Z_\\$][\\w\\$]*(?:\\.[a-zA-Z_\\$][\\w\\$]*)*$");
        this.packageAddButton.setEnabled(p.matcher(this.addNewExcludePackageName.getText()).matches());
    }

    private void handleWsdlVersionComboSelected() {
        this.advanceOptions.put("wv", new String[]{this.wsdlVersionCombo.getItem(this.wsdlVersionCombo.getSelectionIndex())});
    }

    private void fillWSDLVersionCombo() {
        this.wsdlVersionCombo.removeAll();
        this.wsdlVersionCombo.add("1.1");
        this.wsdlVersionCombo.add("2.0");
    }

    private void setCheckBoxState(String type, boolean state) {
        if (state) {
            this.advanceOptions.put(type, null);
        } else {
            this.advanceOptions.remove(type);
        }
    }

    private void setTextBoxValue(String type, String value) {
        if (value.equalsIgnoreCase("")) {
            this.advanceOptions.remove(type);
        } else {
            this.advanceOptions.put(type, new String[]{value});
        }
    }

    public HashMap getAdvanceOptions() {
        return this.advanceOptions;
    }
}

