/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.geometry.core.partitioning.BoundarySource;
import org.apache.commons.geometry.euclidean.threed.BoundaryList3D;
import org.apache.commons.geometry.euclidean.threed.BoundarySourceBoundsBuilder3D;
import org.apache.commons.geometry.euclidean.threed.BoundarySourceLinecaster3D;
import org.apache.commons.geometry.euclidean.threed.Bounds3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.RegionBSPTree3D;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;
import org.apache.commons.geometry.euclidean.threed.line.LinecastPoint3D;
import org.apache.commons.geometry.euclidean.threed.line.Linecastable3D;
import org.apache.commons.geometry.euclidean.threed.mesh.SimpleTriangleMesh;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.numbers.core.Precision;

public interface BoundarySource3D
extends BoundarySource<PlaneConvexSubset>,
Linecastable3D {
    default public BoundaryList3D toList() {
        List boundaries = this.boundaryStream().collect(Collectors.toList());
        return new BoundaryList3D(boundaries);
    }

    default public RegionBSPTree3D toTree() {
        RegionBSPTree3D tree = RegionBSPTree3D.empty();
        tree.insert(this);
        return tree;
    }

    default public TriangleMesh toTriangleMesh(Precision.DoubleEquivalence precision) {
        return SimpleTriangleMesh.from(this, precision);
    }

    default public Stream<Triangle3D> triangleStream() {
        return this.boundaryStream().flatMap(b -> b.toTriangles().stream());
    }

    @Override
    default public List<LinecastPoint3D> linecast(LineConvexSubset3D subset) {
        return new BoundarySourceLinecaster3D(this).linecast(subset);
    }

    @Override
    default public LinecastPoint3D linecastFirst(LineConvexSubset3D subset) {
        return new BoundarySourceLinecaster3D(this).linecastFirst(subset);
    }

    default public Bounds3D getBounds() {
        return new BoundarySourceBoundsBuilder3D().getBounds(this);
    }

    public static BoundarySource3D of(PlaneConvexSubset ... boundaries) {
        return BoundarySource3D.of(Arrays.asList(boundaries));
    }

    public static BoundarySource3D of(Collection<PlaneConvexSubset> boundaries) {
        return boundaries::stream;
    }
}

