/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.Objects;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.EmbeddingHyperplane;
import org.apache.commons.geometry.euclidean.threed.Plane;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.rotation.QuaternionRotation;
import org.apache.commons.geometry.euclidean.twod.AffineTransformMatrix2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.numbers.core.Precision;

public final class EmbeddingPlane
extends Plane
implements EmbeddingHyperplane<Vector3D, Vector2D> {
    private final Vector3D.Unit u;
    private final Vector3D.Unit v;

    EmbeddingPlane(Vector3D.Unit u, Vector3D.Unit v, Vector3D.Unit w, double originOffset, Precision.DoubleEquivalence precision) {
        super(w, originOffset, precision);
        this.u = u;
        this.v = v;
    }

    public Vector3D.Unit getU() {
        return this.u;
    }

    public Vector3D.Unit getV() {
        return this.v;
    }

    public Vector3D.Unit getW() {
        return this.getNormal();
    }

    @Override
    public EmbeddingPlane getEmbedding() {
        return this;
    }

    public Vector2D toSubspace(Vector3D point) {
        return Vector2D.of(point.dot(this.u), point.dot(this.v));
    }

    public Vector3D toSpace(Vector2D point) {
        return Vector3D.Sum.create().addScaled(point.getX(), this.u).addScaled(point.getY(), this.v).addScaled(-this.getOriginOffset(), this.getNormal()).get();
    }

    public Vector3D pointAt(Vector2D inPlane, double offset) {
        return Vector3D.Sum.create().addScaled(inPlane.getX(), this.u).addScaled(inPlane.getY(), this.v).addScaled(offset - this.getOriginOffset(), this.getNormal()).get();
    }

    @Override
    public EmbeddingPlane reverse() {
        return new EmbeddingPlane(this.v, this.u, this.getNormal().negate(), -this.getOriginOffset(), this.getPrecision());
    }

    @Override
    public EmbeddingPlane transform(Transform<Vector3D> transform) {
        Vector3D origin = this.getOrigin();
        Vector3D plusU = origin.add(this.u);
        Vector3D plusV = origin.add(this.v);
        Vector3D tOrigin = (Vector3D)transform.apply((Object)origin);
        Vector3D tPlusU = (Vector3D)transform.apply((Object)plusU);
        Vector3D tPlusV = (Vector3D)transform.apply((Object)plusV);
        Vector3D.Unit tU = tOrigin.directionTo(tPlusU);
        Vector3D.Unit tV = tOrigin.directionTo(tPlusV);
        Vector3D.Unit tW = tU.cross(tV).normalize();
        double tOriginOffset = -tOrigin.dot(tW);
        return new EmbeddingPlane(tU, tV, tW, tOriginOffset, this.getPrecision());
    }

    @Override
    public EmbeddingPlane translate(Vector3D translation) {
        Vector3D tOrigin = this.getOrigin().add(translation);
        return Planes.fromPointAndPlaneVectors(tOrigin, this.u, this.v, this.getPrecision());
    }

    @Override
    public EmbeddingPlane rotate(Vector3D center, QuaternionRotation rotation) {
        Vector3D delta = this.getOrigin().subtract(center);
        Vector3D tOrigin = center.add(rotation.apply(delta));
        Vector3D.Unit tU = rotation.apply(this.u).normalize();
        Vector3D.Unit tV = rotation.apply(this.v).normalize();
        return Planes.fromPointAndPlaneVectors(tOrigin, tU, tV, this.getPrecision());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getNormal(), this.getOriginOffset(), this.u, this.v, this.getPrecision());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != EmbeddingPlane.class) {
            return false;
        }
        EmbeddingPlane other = (EmbeddingPlane)((Object)obj);
        return Objects.equals(this.getNormal(), other.getNormal()) && Double.compare(this.getOriginOffset(), other.getOriginOffset()) == 0 && Objects.equals(this.u, other.u) && Objects.equals(this.v, other.v) && Objects.equals(this.getPrecision(), other.getPrecision());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName()).append("[origin= ").append(this.getOrigin()).append(", u= ").append(this.u).append(", v= ").append(this.v).append(", w= ").append(this.getNormal()).append(']');
        return sb.toString();
    }

    public SubspaceTransform subspaceTransform(Transform<Vector3D> transform) {
        Vector3D origin = this.getOrigin();
        Vector3D tOrigin = (Vector3D)transform.apply((Object)origin);
        Vector3D tPlusU = (Vector3D)transform.apply((Object)origin.add(this.u));
        Vector3D tPlusV = (Vector3D)transform.apply((Object)origin.add(this.v));
        EmbeddingPlane tPlane = Planes.fromPointAndPlaneVectors(tOrigin, tOrigin.vectorTo(tPlusU), tOrigin.vectorTo(tPlusV), this.getPrecision());
        Vector2D tSubspaceOrigin = tPlane.toSubspace(tOrigin);
        Vector2D tSubspaceU = tSubspaceOrigin.vectorTo(tPlane.toSubspace(tPlusU));
        Vector2D tSubspaceV = tSubspaceOrigin.vectorTo(tPlane.toSubspace(tPlusV));
        AffineTransformMatrix2D subspaceTransform = AffineTransformMatrix2D.fromColumnVectors(tSubspaceU, tSubspaceV, tSubspaceOrigin);
        return new SubspaceTransform(tPlane, subspaceTransform);
    }

    public static final class SubspaceTransform {
        private final EmbeddingPlane plane;
        private final AffineTransformMatrix2D transform;

        public SubspaceTransform(EmbeddingPlane plane, AffineTransformMatrix2D transform) {
            this.plane = plane;
            this.transform = transform;
        }

        public EmbeddingPlane getPlane() {
            return this.plane;
        }

        public AffineTransformMatrix2D getTransform() {
            return this.transform;
        }
    }
}

