/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.Objects;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.Vector;
import org.apache.commons.geometry.core.partitioning.AbstractHyperplane;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.euclidean.MultiDimensionalEuclideanVector;
import org.apache.commons.geometry.euclidean.threed.EmbeddingPlane;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.Line3D;
import org.apache.commons.geometry.euclidean.threed.line.Lines3D;
import org.apache.commons.geometry.euclidean.threed.rotation.QuaternionRotation;
import org.apache.commons.geometry.euclidean.twod.ConvexArea;
import org.apache.commons.numbers.core.Precision;

public class Plane
extends AbstractHyperplane<Vector3D> {
    private final Vector3D.Unit normal;
    private final double originOffset;

    Plane(Vector3D.Unit normal, double originOffset, Precision.DoubleEquivalence precision) {
        super(precision);
        this.normal = normal;
        this.originOffset = originOffset;
    }

    public Vector3D getOrigin() {
        return this.normal.multiply(-this.originOffset);
    }

    public double getOriginOffset() {
        return this.originOffset;
    }

    public Vector3D.Unit getNormal() {
        return this.normal;
    }

    public EmbeddingPlane getEmbedding() {
        MultiDimensionalEuclideanVector u = this.normal.orthogonal();
        Vector3D.Unit v = this.normal.cross((Vector3D)u).normalize();
        return new EmbeddingPlane((Vector3D.Unit)u, v, this.normal, this.originOffset, this.getPrecision());
    }

    public double offset(Vector3D point) {
        return point.dot(this.normal) + this.originOffset;
    }

    public double offset(Line3D line) {
        if (!this.isParallel(line)) {
            return 0.0;
        }
        return this.offset(line.getOrigin());
    }

    public double offset(Plane plane) {
        if (!this.isParallel(plane)) {
            return 0.0;
        }
        return this.originOffset + (this.similarOrientation((Hyperplane<Vector3D>)plane) ? -plane.originOffset : plane.originOffset);
    }

    public boolean contains(Vector3D p) {
        return this.getPrecision().eqZero(this.offset(p));
    }

    public boolean contains(Line3D line) {
        return this.isParallel(line) && this.contains(line.getOrigin());
    }

    public boolean contains(Plane plane) {
        double angle = this.normal.angle(plane.normal);
        Precision.DoubleEquivalence precision = this.getPrecision();
        return precision.eqZero(angle) && precision.eq(this.originOffset, plane.originOffset) || precision.eq(angle, Math.PI) && precision.eq(this.originOffset, -plane.originOffset);
    }

    public Vector3D project(Vector3D point) {
        return this.getOrigin().add(point.reject(this.normal));
    }

    public Line3D project(Line3D line) {
        Vector3D direction = line.getDirection();
        Vector projection = this.normal.multiply(direction.dot(this.normal) * (1.0 / this.normal.normSq()));
        Vector3D projectedLineDirection = direction.subtract((Vector3D)projection);
        Vector3D p1 = this.project(line.getOrigin());
        Vector3D p2 = p1.add(projectedLineDirection);
        return Lines3D.fromPoints(p1, p2, this.getPrecision());
    }

    public PlaneConvexSubset span() {
        return Planes.subsetFromConvexArea(this.getEmbedding(), ConvexArea.full());
    }

    public boolean isParallel(Line3D line) {
        double dot = this.normal.dot(line.getDirection());
        return this.getPrecision().eqZero(dot);
    }

    public boolean isParallel(Plane plane) {
        return this.getPrecision().eqZero(this.normal.cross(plane.normal).norm());
    }

    public boolean similarOrientation(Hyperplane<Vector3D> other) {
        return ((Plane)other).normal.dot(this.normal) > 0.0;
    }

    public Vector3D intersection(Line3D line) {
        Vector3D direction = line.getDirection();
        double dot = this.normal.dot(direction);
        if (this.getPrecision().eqZero(dot)) {
            return null;
        }
        Vector3D point = line.pointAt(0.0);
        double k = -(this.originOffset + this.normal.dot(point)) / dot;
        return Vector3D.Sum.of(point).addScaled(k, direction).get();
    }

    public Line3D intersection(Plane other) {
        Vector3D direction = this.normal.cross(other.normal);
        if (this.getPrecision().eqZero(direction.norm())) {
            return null;
        }
        Vector3D point = Plane.intersection(this, other, Planes.fromNormal(direction, this.getPrecision()));
        return Lines3D.fromPointAndDirection(point, direction, this.getPrecision());
    }

    public Plane reverse() {
        return new Plane(this.normal.negate(), -this.originOffset, this.getPrecision());
    }

    public Plane transform(Transform<Vector3D> transform) {
        MultiDimensionalEuclideanVector u = this.normal.orthogonal();
        Vector3D v = this.normal.cross((Vector3D)u);
        Vector3D p1 = this.getOrigin();
        Vector3D p2 = p1.add((Vector3D)u);
        Vector3D p3 = p1.add(v);
        Vector3D t1 = (Vector3D)transform.apply((Object)p1);
        Vector3D t2 = (Vector3D)transform.apply((Object)p2);
        Vector3D t3 = (Vector3D)transform.apply((Object)p3);
        return Planes.fromPoints(t1, t2, t3, this.getPrecision());
    }

    public Plane translate(Vector3D translation) {
        Vector3D tOrigin = this.getOrigin().add(translation);
        return Planes.fromPointAndNormal(tOrigin, this.normal, this.getPrecision());
    }

    public Plane rotate(Vector3D center, QuaternionRotation rotation) {
        Vector3D delta = this.getOrigin().subtract(center);
        Vector3D tOrigin = center.add(rotation.apply(delta));
        Vector3D.Unit tNormal = rotation.apply(this.normal).normalize();
        return Planes.fromPointAndNormal(tOrigin, tNormal, this.getPrecision());
    }

    public boolean eq(Plane other, Precision.DoubleEquivalence precision) {
        return this.getOrigin().eq(other.getOrigin(), precision) && this.normal.eq(other.normal, precision);
    }

    public int hashCode() {
        return Objects.hash(this.normal, this.originOffset, this.getPrecision());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Plane other = (Plane)((Object)obj);
        return Objects.equals(this.normal, other.normal) && Double.compare(this.originOffset, other.originOffset) == 0 && Objects.equals(this.getPrecision(), other.getPrecision());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName()).append("[origin= ").append(this.getOrigin()).append(", normal= ").append(this.normal).append(']');
        return sb.toString();
    }

    public static Vector3D intersection(Plane plane1, Plane plane2, Plane plane3) {
        double a1 = plane1.normal.getX();
        double b1 = plane1.normal.getY();
        double c1 = plane1.normal.getZ();
        double d1 = plane1.originOffset;
        double a2 = plane2.normal.getX();
        double b2 = plane2.normal.getY();
        double c2 = plane2.normal.getZ();
        double d2 = plane2.originOffset;
        double a3 = plane3.normal.getX();
        double b3 = plane3.normal.getY();
        double c3 = plane3.normal.getZ();
        double d3 = plane3.originOffset;
        double a23 = b2 * c3 - b3 * c2;
        double b23 = c2 * a3 - c3 * a2;
        double c23 = a2 * b3 - a3 * b2;
        double determinant = a1 * a23 + b1 * b23 + c1 * c23;
        if (plane1.getPrecision().eqZero(determinant)) {
            return null;
        }
        double r = 1.0 / determinant;
        return Vector3D.of((-a23 * d1 - (c1 * b3 - c3 * b1) * d2 - (c2 * b1 - c1 * b2) * d3) * r, (-b23 * d1 - (c3 * a1 - c1 * a3) * d2 - (c1 * a2 - c2 * a1) * d3) * r, (-c23 * d1 - (b1 * a3 - b3 * a1) * d2 - (b2 * a1 - b1 * a2) * d3) * r);
    }
}

