/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3;

import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public class JCSRemovalSimpleConcurrentTest
extends TestCase {
    private CacheAccess<String, String> jcs;

    public void setUp() throws Exception {
        JCS.setConfigFilename((String)"/TestRemoval.ccf");
        this.jcs = JCS.getInstance((String)"testCache1");
    }

    public void testTwoDeepRemoval() throws Exception {
        int i;
        int count = 500;
        for (i = 0; i <= 500; ++i) {
            this.jcs.put((Object)("key:" + i + ":anotherpart"), (Object)("data" + i));
        }
        for (i = 500; i >= 0; --i) {
            String res = (String)this.jcs.get((Object)("key:" + i + ":anotherpart"));
            JCSRemovalSimpleConcurrentTest.assertNotNull((String)("[key:" + i + ":anotherpart] should not be null, " + this.jcs.getStats()), (Object)res);
        }
        for (i = 0; i <= 500; ++i) {
            this.jcs.remove((Object)("key:" + i + ":"));
            JCSRemovalSimpleConcurrentTest.assertNull((String)this.jcs.getStats(), (Object)this.jcs.get((Object)("key:" + i + ":anotherpart")));
        }
    }

    public void testSingleDepthRemoval() throws Exception {
        int i;
        int count = 500;
        for (i = 0; i <= 500; ++i) {
            this.jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = 500; i >= 0; --i) {
            String res = (String)this.jcs.get((Object)(i + ":key"));
            JCSRemovalSimpleConcurrentTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        for (i = 0; i <= 500; ++i) {
            this.jcs.remove((Object)(i + ":"));
            JCSRemovalSimpleConcurrentTest.assertNull((Object)this.jcs.get((Object)(i + ":key")));
        }
    }

    public void testClear() throws Exception {
        String res;
        int i;
        int count = 500;
        for (i = 0; i <= 500; ++i) {
            this.jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = 500; i >= 0; --i) {
            res = (String)this.jcs.get((Object)(i + ":key"));
            JCSRemovalSimpleConcurrentTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        this.jcs.clear();
        for (i = 500; i >= 0; --i) {
            res = (String)this.jcs.get((Object)(i + ":key"));
            if (res == null) continue;
            JCSRemovalSimpleConcurrentTest.assertNull((String)("[" + i + ":key] should be null after remvoeall" + this.jcs.getStats()), (Object)res);
        }
    }

    public void testClearRepeatedlyWithoutError() throws Exception {
        String res;
        int i;
        int count = 500;
        this.jcs.clear();
        for (i = 0; i <= 500; ++i) {
            this.jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = 500; i >= 0; --i) {
            res = (String)this.jcs.get((Object)(i + ":key"));
            JCSRemovalSimpleConcurrentTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        for (i = 500; i >= 0; --i) {
            this.jcs.put((Object)(i + ":key"), (Object)("data" + i));
            this.jcs.clear();
            res = (String)this.jcs.get((Object)(i + ":key"));
            if (res == null) continue;
            JCSRemovalSimpleConcurrentTest.assertNull((String)("[" + i + ":key] should be null after remvoeall" + this.jcs.getStats()), (Object)res);
        }
    }
}

