/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.CanReadFileFilter;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class CanReadFileFilterTest
extends BaseFilterTest {
    private static final String WRITABLE = "writable.txt";
    private static final String READONLY = "readonly.txt";
    private static File testDir;
    private static File writableFile;
    private static FileSelectInfo writableFileInfo;
    private static File readOnlyFile;
    private static FileSelectInfo readOnlyFileInfo;
    private static File notExistingFile;
    private static FileSelectInfo notExistingFileInfo;
    private static File zipFile;
    private static FileObject zipFileObj;

    @AfterAll
    public static void afterClass() throws IOException {
        writableFileInfo = null;
        CanReadFileFilterTest.delete(writableFile);
        writableFile = null;
        readOnlyFileInfo = null;
        CanReadFileFilterTest.delete(readOnlyFile);
        readOnlyFile = null;
        notExistingFileInfo = null;
        notExistingFile = null;
        IOUtils.close((Closeable)zipFileObj);
        FileUtils.deleteQuietly((File)zipFile);
        zipFile = null;
        FileUtils.deleteDirectory((File)testDir);
        testDir = null;
    }

    @BeforeAll
    public static void beforeClass() throws IOException {
        testDir = CanReadFileFilterTest.getTestDir(CanReadFileFilterTest.class.getName());
        writableFile = new File(testDir, WRITABLE);
        writableFileInfo = CanReadFileFilterTest.createFileSelectInfo(writableFile);
        FileUtils.touch((File)writableFile);
        readOnlyFile = new File(testDir, READONLY);
        readOnlyFileInfo = CanReadFileFilterTest.createFileSelectInfo(readOnlyFile);
        FileUtils.touch((File)readOnlyFile);
        readOnlyFile.setReadable(true);
        readOnlyFile.setWritable(false);
        notExistingFile = new File(testDir, "not-existing-file.txt");
        notExistingFileInfo = CanReadFileFilterTest.createFileSelectInfo(notExistingFile);
        zipFile = new File(CanReadFileFilterTest.getTempDir(), CanReadFileFilterTest.class.getName() + ".zip");
        CanReadFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObj = CanReadFileFilterTest.getZipFileObject(zipFile);
    }

    @Test
    public void testAcceptCannotRead() throws FileSystemException {
        Assertions.assertFalse((boolean)CanReadFileFilter.CANNOT_READ.accept(writableFileInfo));
        Assertions.assertFalse((boolean)CanReadFileFilter.CANNOT_READ.accept(readOnlyFileInfo));
        Assertions.assertTrue((boolean)CanReadFileFilter.CANNOT_READ.accept(notExistingFileInfo));
    }

    @Test
    public void testAcceptCanRead() throws FileSystemException {
        Assertions.assertTrue((boolean)CanReadFileFilter.CAN_READ.accept(writableFileInfo));
        Assertions.assertTrue((boolean)CanReadFileFilter.CAN_READ.accept(readOnlyFileInfo));
        Assertions.assertFalse((boolean)CanReadFileFilter.CAN_READ.accept(notExistingFileInfo));
    }

    @Test
    public void testAcceptReadOnly() throws FileSystemException {
        Assertions.assertFalse((boolean)CanReadFileFilter.READ_ONLY.accept(writableFileInfo));
        Assertions.assertTrue((boolean)CanReadFileFilter.READ_ONLY.accept(readOnlyFileInfo));
        Assertions.assertFalse((boolean)CanReadFileFilter.READ_ONLY.accept(notExistingFileInfo));
    }

    @Test
    public void testAcceptZipFile() throws FileSystemException {
        FileObject[] files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(CanReadFileFilter.CAN_READ));
        this.assertContains(files, READONLY, WRITABLE);
        Assertions.assertEquals((int)2, (int)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(CanReadFileFilter.CANNOT_READ));
        Assertions.assertTrue((files == null || files.length == 0 ? 1 : 0) != 0);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(CanReadFileFilter.READ_ONLY));
        this.assertContains(files, READONLY, WRITABLE);
        Assertions.assertEquals((int)2, (int)files.length);
    }
}

