/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.MessagePassingQueue;

public final class MessagePassingQueueUtil {
    private MessagePassingQueueUtil() {
    }

    public static <E> int drain(MessagePassingQueue<? extends E> queue, MessagePassingQueue.Consumer<? super E> c, int limit) {
        E e;
        int i;
        for (i = 0; i < limit && (e = queue.relaxedPoll()) != null; ++i) {
            c.accept(e);
        }
        return i;
    }

    public static <E> int drain(MessagePassingQueue<? extends E> queue, MessagePassingQueue.Consumer<? super E> c) {
        E e;
        int i = 0;
        while ((e = queue.relaxedPoll()) != null) {
            ++i;
            c.accept(e);
        }
        return i;
    }

    public static <E> void drain(MessagePassingQueue<? extends E> queue, MessagePassingQueue.Consumer<? super E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        int idleCounter = 0;
        while (exit.keepRunning()) {
            E e = queue.relaxedPoll();
            if (e == null) {
                idleCounter = wait.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
            c.accept(e);
        }
    }
}

