/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.PrintStream;
import java.util.ArrayList;

public class TableOut {
    final String separator;
    final int[] columnSizes;
    final int indentation;
    final String indentationString;

    public TableOut(String separator, int indentation, int[] columnSizes) {
        this.separator = separator;
        this.columnSizes = columnSizes;
        this.indentation = indentation;
        StringBuilder indentBuilder = new StringBuilder();
        for (int i = 0; i < indentation; ++i) {
            indentBuilder.append(' ');
        }
        this.indentationString = indentBuilder.toString();
    }

    public void print(PrintStream stream, String[] columns) {
        this.print(stream, columns, null);
    }

    public void print(PrintStream stream, String[] columns, boolean[] center) {
        ArrayList[] splitColumns = new ArrayList[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            splitColumns[i] = this.splitLine(columns[i], this.columnSizes[i]);
        }
        this.print(stream, splitColumns, center);
    }

    public void print(PrintStream stream, ArrayList<String>[] splitColumns) {
        this.print(stream, splitColumns, null);
    }

    public void print(PrintStream stream, ArrayList<String>[] splitColumns, boolean[] centralize) {
        boolean hasMoreLines;
        int lineNumber = 0;
        do {
            hasMoreLines = false;
            stream.print(this.separator);
            for (int column = 0; column < splitColumns.length; ++column) {
                StringBuilder cell = new StringBuilder();
                String cellString = lineNumber < splitColumns[column].size() ? splitColumns[column].get(lineNumber) : "";
                if (centralize != null && centralize[column] && cellString.length() > 0) {
                    int centralAdd = (this.columnSizes[column] - cellString.length()) / 2;
                    for (int i = 0; i < centralAdd; ++i) {
                        cell.append(' ');
                    }
                }
                cell.append(cellString);
                if (lineNumber + 1 < splitColumns[column].size()) {
                    hasMoreLines = true;
                }
                while (cell.length() < this.columnSizes[column]) {
                    cell.append(" ");
                }
                stream.print(cell);
                stream.print(this.separator);
            }
            stream.println();
            ++lineNumber;
        } while (hasMoreLines);
    }

    public ArrayList<String> splitLine(String column, int size) {
        int maxPosition;
        ArrayList<String> cells = new ArrayList<String>();
        for (int position = 0; position < column.length(); position += maxPosition) {
            String identationStringUsed;
            int identationUsed;
            if (position == 0 || this.indentation == 0) {
                identationUsed = 0;
                identationStringUsed = "";
            } else {
                identationUsed = this.indentation;
                identationStringUsed = this.indentationString;
            }
            maxPosition = Math.min(size - identationUsed, column.length() - position);
            cells.add(identationStringUsed + column.substring(position, position + maxPosition));
        }
        return cells;
    }
}

