/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Locale;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.sampling.ReservoirSize;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int LG_RESIZE_FACTOR_BIT = 6;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int FLAGS_BYTE = 3;
    static final int RESERVOIR_SIZE_SHORT = 4;
    static final int RESERVOIR_SIZE_INT = 4;
    static final int SERDE_ID_SHORT = 6;
    static final int ITEMS_SEEN_LONG = 8;
    static final int MAX_K_SIZE_INT = 4;
    static final int OUTER_TAU_NUM_DOUBLE = 16;
    static final int OUTER_TAU_DENOM_LONG = 24;
    static final int ITEM_COUNT_H_INT = 16;
    static final int ITEM_COUNT_R_INT = 20;
    static final int TOTAL_WEIGHT_R_DOUBLE = 24;
    static final int VO_PRELONGS_EMPTY = Family.VAROPT.getMinPreLongs();
    static final int VO_PRELONGS_WARMUP = 3;
    static final int VO_PRELONGS_FULL = Family.VAROPT.getMaxPreLongs();
    static final int EBPPS_CUM_WT_DOUBLE = 16;
    static final int EBPPS_MAX_WT_DOUBLE = 24;
    static final int EBPPS_RHO_DOUBLE = 32;
    static final int EMPTY_FLAG_MASK = 4;
    static final int HAS_PARTIAL_ITEM_MASK = 8;
    static final int GADGET_FLAG_MASK = 128;
    static final int RESERVOIR_SER_VER = 2;
    static final int VAROPT_SER_VER = 2;
    static final int EBPPS_SER_VER = 1;

    private PreambleUtil() {
    }

    static String preambleToString(byte[] byteArr) {
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        return PreambleUtil.preambleToString(seg);
    }

    static String preambleToString(MemorySegment seg) {
        int preLongs = PreambleUtil.getAndCheckPreLongs(seg);
        Family family = Family.idToFamily(seg.get(ValueLayout.JAVA_BYTE, 2L));
        switch (family) {
            case RESERVOIR: 
            case VAROPT: {
                return PreambleUtil.sketchPreambleToString(seg, family, preLongs);
            }
            case RESERVOIR_UNION: 
            case VAROPT_UNION: {
                return PreambleUtil.unionPreambleToString(seg, family, preLongs);
            }
        }
        throw new SketchesArgumentException("Inspecting preamble with Sampling family's PreambleUtil with object of family " + family.getFamilyName());
    }

    private static String sketchPreambleToString(MemorySegment seg, Family family, int preLongs) {
        int k;
        boolean isGadget;
        ResizeFactor rf = ResizeFactor.getRF(PreambleUtil.extractResizeFactor(seg));
        int serVer = PreambleUtil.extractSerVer(seg);
        int flags = PreambleUtil.extractFlags(seg);
        String flagsStr = Util.zeroPad(Integer.toBinaryString(flags), 8) + ", " + flags;
        boolean isEmpty = (flags & 4) > 0;
        boolean bl = isGadget = (flags & 0x80) > 0;
        if (serVer == 1) {
            short encK = PreambleUtil.extractEncodedReservoirSize(seg);
            k = ReservoirSize.decodeValue(encK);
        } else {
            k = PreambleUtil.extractK(seg);
        }
        long n = 0L;
        if (!isEmpty) {
            n = PreambleUtil.extractN(seg);
        }
        long dataBytes = seg.byteSize() - (long)(preLongs << 3);
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS).append("### END ").append(family.getFamilyName().toUpperCase(Locale.US)).append(" PREAMBLE SUMMARY").append(Util.LS).append("Byte  0: Preamble Longs       : ").append(preLongs).append(Util.LS).append("Byte  0: ResizeFactor         : ").append(rf.toString()).append(Util.LS).append("Byte  1: Serialization Version: ").append(serVer).append(Util.LS).append("Byte  2: Family               : ").append(family.toString()).append(Util.LS).append("Byte  3: Flags Field          : ").append(flagsStr).append(Util.LS).append("  EMPTY                       : ").append(isEmpty).append(Util.LS);
        if (family == Family.VAROPT) {
            sb.append("  GADGET                      : ").append(isGadget).append(Util.LS);
        }
        sb.append("Bytes  4-7: Sketch Size (k)   : ").append(k).append(Util.LS);
        if (!isEmpty) {
            sb.append("Bytes 8-15: Items Seen (n)    : ").append(n).append(Util.LS);
        }
        if (family == Family.VAROPT && !isEmpty) {
            int hCount = PreambleUtil.extractHRegionItemCount(seg);
            int rCount = PreambleUtil.extractRRegionItemCount(seg);
            double totalRWeight = PreambleUtil.extractTotalRWeight(seg);
            sb.append("Bytes 16-19: H region count   : ").append(hCount).append(Util.LS).append("Bytes 20-23: R region count   : ").append(rCount).append(Util.LS);
            if (rCount > 0) {
                sb.append("Bytes 24-31: R region weight  : ").append(totalRWeight).append(Util.LS);
            }
        }
        sb.append("TOTAL Sketch Bytes            : ").append(seg.byteSize()).append(Util.LS).append("  Preamble Bytes              : ").append(preLongs << 3).append(Util.LS).append("  Data Bytes                  : ").append(dataBytes).append(Util.LS).append("### END ").append(family.getFamilyName().toUpperCase(Locale.US)).append(" PREAMBLE SUMMARY").append(Util.LS);
        return sb.toString();
    }

    private static String unionPreambleToString(MemorySegment seg, Family family, int preLongs) {
        int k;
        boolean isEmpty;
        ResizeFactor rf = ResizeFactor.getRF(PreambleUtil.extractResizeFactor(seg));
        int serVer = PreambleUtil.extractSerVer(seg);
        int flags = PreambleUtil.extractFlags(seg);
        String flagsStr = Util.zeroPad(Integer.toBinaryString(flags), 8) + ", " + flags;
        boolean bl = isEmpty = (flags & 4) > 0;
        if (serVer == 1) {
            short encK = PreambleUtil.extractEncodedReservoirSize(seg);
            k = ReservoirSize.decodeValue(encK);
        } else {
            k = PreambleUtil.extractK(seg);
        }
        long dataBytes = seg.byteSize() - (long)(preLongs << 3);
        return Util.LS + "### END " + family.getFamilyName().toUpperCase(Locale.US) + " PREAMBLE SUMMARY" + Util.LS + "Byte  0: Preamble Longs           : " + preLongs + Util.LS + "Byte  0: ResizeFactor             : " + rf.toString() + Util.LS + "Byte  1: Serialization Version    : " + serVer + Util.LS + "Byte  2: Family                   : " + family.toString() + Util.LS + "Byte  3: Flags Field              : " + flagsStr + Util.LS + "  EMPTY                           : " + isEmpty + Util.LS + "Bytes  4-7: Max Sketch Size (maxK): " + k + Util.LS + "TOTAL Sketch Bytes                : " + seg.byteSize() + Util.LS + "  Preamble Bytes                  : " + (preLongs << 3) + Util.LS + "  Sketch Bytes                    : " + dataBytes + Util.LS + "### END " + family.getFamilyName().toUpperCase(Locale.US) + " PREAMBLE SUMMARY" + Util.LS;
    }

    static int extractPreLongs(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 0L) & 0x3F;
    }

    static int extractResizeFactor(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 0L) >>> 6 & 3;
    }

    static int extractSerVer(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 1L) & 0xFF;
    }

    static int extractFamilyID(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 2L) & 0xFF;
    }

    static int extractFlags(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 3L) & 0xFF;
    }

    static short extractEncodedReservoirSize(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, 4L);
    }

    static int extractK(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_INT_UNALIGNED, 4L);
    }

    static int extractMaxK(MemorySegment seg) {
        return PreambleUtil.extractK(seg);
    }

    static long extractN(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
    }

    static int extractHRegionItemCount(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_INT_UNALIGNED, 16L);
    }

    static int extractRRegionItemCount(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_INT_UNALIGNED, 20L);
    }

    static double extractTotalRWeight(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L);
    }

    static double extractOuterTauNumerator(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 16L);
    }

    static long extractOuterTauDenominator(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 24L);
    }

    static double extractEbppsCumulativeWeight(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 16L);
    }

    static double extractEbppsMaxWeight(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L);
    }

    static double extractEbppsRho(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 32L);
    }

    static void insertPreLongs(MemorySegment wseg, int preLongs) {
        byte curByte = wseg.get(ValueLayout.JAVA_BYTE, 0L);
        int mask = 63;
        byte newByte = (byte)(preLongs & 0x3F | 0xFFFFFFC0 & curByte);
        wseg.set(ValueLayout.JAVA_BYTE, 0L, newByte);
    }

    static void insertLgResizeFactor(MemorySegment wseg, int rf) {
        byte curByte = wseg.get(ValueLayout.JAVA_BYTE, 0L);
        int shift = 6;
        int mask = 3;
        byte newByte = (byte)((rf & 3) << 6 | 0xFFFFFF3F & curByte);
        wseg.set(ValueLayout.JAVA_BYTE, 0L, newByte);
    }

    static void insertSerVer(MemorySegment wseg, int serVer) {
        wseg.set(ValueLayout.JAVA_BYTE, 1L, (byte)serVer);
    }

    static void insertFamilyID(MemorySegment wseg, int famId) {
        wseg.set(ValueLayout.JAVA_BYTE, 2L, (byte)famId);
    }

    static void insertFlags(MemorySegment wseg, int flags) {
        wseg.set(ValueLayout.JAVA_BYTE, 3L, (byte)flags);
    }

    static void insertK(MemorySegment wseg, int k) {
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, 4L, k);
    }

    static void insertMaxK(MemorySegment wseg, int maxK) {
        PreambleUtil.insertK(wseg, maxK);
    }

    static void insertN(MemorySegment wseg, long totalSeen) {
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, totalSeen);
    }

    static void insertHRegionItemCount(MemorySegment wseg, int hCount) {
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, 16L, hCount);
    }

    static void insertRRegionItemCount(MemorySegment wseg, int rCount) {
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, 20L, rCount);
    }

    static void insertTotalRWeight(MemorySegment wseg, double weight) {
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L, weight);
    }

    static void insertOuterTauNumerator(MemorySegment wseg, double numer) {
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 16L, numer);
    }

    static void insertOuterTauDenominator(MemorySegment wseg, long denom) {
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 24L, denom);
    }

    static void insertEbppsCumulativeWeight(MemorySegment wseg, double cumWt) {
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 16L, cumWt);
    }

    static void insertEbppsMaxWeight(MemorySegment wseg, double maxWt) {
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L, maxWt);
    }

    static void insertEbppsRho(MemorySegment wseg, double rho) {
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 32L, rho);
    }

    static int getAndCheckPreLongs(MemorySegment seg) {
        int preLongs;
        int required;
        long cap = seg.byteSize();
        if (cap < 8L) {
            PreambleUtil.throwNotBigEnough(cap, 8);
        }
        if (cap < (long)(required = Math.max((preLongs = seg.get(ValueLayout.JAVA_BYTE, 0L) & 0x3F) << 3, 8))) {
            PreambleUtil.throwNotBigEnough(cap, required);
        }
        return preLongs;
    }

    private static void throwNotBigEnough(long cap, int required) {
        throw new SketchesArgumentException("Possible Corruption: Size of byte array or MemorySegment not large enough: Size: " + cap + ", Required: " + required);
    }
}

