/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.sampling.PreambleUtil;
import org.apache.datasketches.sampling.ReservoirItemsSketch;
import org.apache.datasketches.sampling.VarOptItemsSamples;
import org.apache.datasketches.sampling.VarOptItemsSketch;

public final class VarOptItemsUnion<T> {
    private VarOptItemsSketch<T> gadget_;
    private final int maxK_;
    private long n_;
    private double outerTauNumer;
    private long outerTauDenom;

    private VarOptItemsUnion(int maxK) {
        this.maxK_ = maxK;
        this.n_ = 0L;
        this.outerTauNumer = 0.0;
        this.outerTauDenom = 0L;
        this.gadget_ = VarOptItemsSketch.newInstanceAsGadget(maxK);
    }

    public static <T> VarOptItemsUnion<T> newInstance(int maxK) {
        return new VarOptItemsUnion<T>(maxK);
    }

    public static <T> VarOptItemsUnion<T> heapify(MemorySegment srcSeg, ArrayOfItemsSerDe<T> serDe) {
        boolean preLongsEqMax;
        Family.VAROPT_UNION.checkFamilyID(srcSeg.get(ValueLayout.JAVA_BYTE, 2L));
        long n = 0L;
        double outerTauNum = 0.0;
        long outerTauDenom = 0L;
        int numPreLongs = PreambleUtil.extractPreLongs(srcSeg);
        int serVer = PreambleUtil.extractSerVer(srcSeg);
        boolean isEmpty = (PreambleUtil.extractFlags(srcSeg) & 4) != 0;
        int maxK = PreambleUtil.extractMaxK(srcSeg);
        if (!isEmpty) {
            n = PreambleUtil.extractN(srcSeg);
            outerTauNum = PreambleUtil.extractOuterTauNumerator(srcSeg);
            outerTauDenom = PreambleUtil.extractOuterTauDenominator(srcSeg);
        }
        if (serVer != 2) {
            throw new SketchesArgumentException("Possible Corruption: Ser Ver must be 2: " + serVer);
        }
        boolean preLongsEqMin = numPreLongs == Family.VAROPT_UNION.getMinPreLongs();
        boolean bl = preLongsEqMax = numPreLongs == Family.VAROPT_UNION.getMaxPreLongs();
        if (!preLongsEqMin && !preLongsEqMax) {
            throw new SketchesArgumentException("Possible corruption: Non-empty union with only " + Family.VAROPT_UNION.getMinPreLongs() + "preLongs");
        }
        VarOptItemsUnion<T> viu = new VarOptItemsUnion<T>(maxK);
        if (isEmpty) {
            viu.gadget_ = VarOptItemsSketch.newInstanceAsGadget(maxK);
        } else {
            viu.n_ = n;
            viu.outerTauNumer = outerTauNum;
            viu.outerTauDenom = outerTauDenom;
            int preLongBytes = numPreLongs << 3;
            MemorySegment sketchSeg = srcSeg.asSlice(preLongBytes);
            viu.gadget_ = VarOptItemsSketch.heapify(sketchSeg, serDe);
        }
        return viu;
    }

    public void update(VarOptItemsSketch<T> sketchIn) {
        if (sketchIn != null) {
            this.mergeInto(sketchIn);
        }
    }

    public void update(MemorySegment seg, ArrayOfItemsSerDe<T> serDe) {
        if (seg != null) {
            VarOptItemsSketch<T> vis = VarOptItemsSketch.heapify(seg, serDe);
            this.mergeInto(vis);
        }
    }

    public void update(ReservoirItemsSketch<T> reservoirIn) {
        if (reservoirIn != null) {
            this.mergeReservoirInto(reservoirIn);
        }
    }

    public VarOptItemsSketch<T> getResult() {
        if (this.gadget_.getNumMarksInH() == 0) {
            return this.simpleGadgetCoercer();
        }
        VarOptItemsSketch<T> tmp = this.detectAndHandleSubcaseOfPseudoExact();
        if (tmp != null) {
            return tmp;
        }
        return this.migrateMarkedItemsByDecreasingK();
    }

    public void reset() {
        this.gadget_.reset();
        this.n_ = 0L;
        this.outerTauNumer = 0.0;
        this.outerTauDenom = 0L;
    }

    public String toString() {
        assert (this.gadget_ != null);
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        sb.append(Util.LS).append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS).append("   Max k: ").append(this.maxK_).append(Util.LS).append("   Gadget summary: ").append(this.gadget_.toString()).append("### END UNION SUMMARY").append(Util.LS);
        return sb.toString();
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe) {
        assert (this.gadget_ != null);
        if (this.gadget_.getNumSamples() == 0) {
            return this.toByteArray(serDe, null);
        }
        return this.toByteArray(serDe, this.gadget_.getItem(0).getClass());
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe, Class<?> clazz) {
        int outBytes;
        int preLongs;
        byte[] gadgetBytes;
        boolean empty = this.gadget_.getNumSamples() == 0;
        byte[] byArray = gadgetBytes = empty ? null : this.gadget_.toByteArray(serDe, clazz);
        if (empty) {
            preLongs = Family.VAROPT_UNION.getMinPreLongs();
            outBytes = 8;
        } else {
            preLongs = Family.VAROPT_UNION.getMaxPreLongs();
            outBytes = (preLongs << 3) + gadgetBytes.length;
        }
        byte[] outArr = new byte[outBytes];
        MemorySegment seg = MemorySegment.ofArray(outArr);
        PreambleUtil.insertPreLongs(seg, preLongs);
        PreambleUtil.insertSerVer(seg, 2);
        PreambleUtil.insertFamilyID(seg, Family.VAROPT_UNION.getID());
        if (empty) {
            PreambleUtil.insertFlags(seg, 4);
        } else {
            PreambleUtil.insertFlags(seg, 0);
        }
        PreambleUtil.insertMaxK(seg, this.maxK_);
        if (!empty) {
            PreambleUtil.insertN(seg, this.n_);
            PreambleUtil.insertOuterTauNumerator(seg, this.outerTauNumer);
            PreambleUtil.insertOuterTauDenominator(seg, this.outerTauDenom);
            int preBytes = preLongs << 3;
            MemorySegment.copy(gadgetBytes, 0, seg, ValueLayout.JAVA_BYTE, (long)preBytes, gadgetBytes.length);
        }
        return outArr;
    }

    double getOuterTau() {
        if (this.outerTauDenom == 0L) {
            return 0.0;
        }
        return this.outerTauNumer / (double)this.outerTauDenom;
    }

    private void mergeInto(VarOptItemsSketch<T> sketch) {
        VarOptItemsSamples.WeightedSample ws;
        long sketchN = sketch.getN();
        if (sketchN == 0L) {
            return;
        }
        this.n_ += sketchN;
        VarOptItemsSamples<T> sketchSamples = sketch.getSketchSamples();
        Iterator<VarOptItemsSamples.WeightedSample> sketchIterator = sketchSamples.getHIterator();
        while (sketchIterator.hasNext()) {
            ws = sketchIterator.next();
            this.gadget_.update(ws.getItem(), ws.getWeight(), false);
        }
        sketchIterator = sketchSamples.getWeightCorrRIter();
        while (sketchIterator.hasNext()) {
            ws = sketchIterator.next();
            this.gadget_.update(ws.getItem(), ws.getWeight(), true);
        }
        if (sketch.getRRegionCount() > 0) {
            double sketchTau = sketch.getTau();
            double outerTau = this.getOuterTau();
            if (this.outerTauDenom == 0L) {
                this.outerTauNumer = sketch.getTotalWtR();
                this.outerTauDenom = sketch.getRRegionCount();
            } else if (sketchTau > outerTau) {
                this.outerTauNumer = sketch.getTotalWtR();
                this.outerTauDenom = sketch.getRRegionCount();
            } else if (sketchTau == outerTau) {
                this.outerTauNumer += sketch.getTotalWtR();
                this.outerTauDenom += (long)sketch.getRRegionCount();
            }
        }
    }

    private void mergeReservoirInto(ReservoirItemsSketch<T> reservoir) {
        long reservoirN = reservoir.getN();
        if (reservoirN == 0L) {
            return;
        }
        this.n_ += reservoirN;
        int reservoirK = reservoir.getK();
        if (reservoir.getN() <= (long)reservoirK) {
            for (T item : reservoir.getRawSamplesAsList()) {
                this.gadget_.update(item, 1.0, false);
            }
        } else {
            double reservoirTau = reservoir.getImplicitSampleWeight();
            double cumWeight = 0.0;
            ArrayList<T> samples = reservoir.getRawSamplesAsList();
            for (int i = 0; i < reservoirK - 1; ++i) {
                this.gadget_.update(samples.get(i), reservoirTau, true);
                cumWeight += reservoirTau;
            }
            this.gadget_.update(samples.get(reservoirK - 1), (double)reservoir.getN() - cumWeight, true);
            double outerTau = this.getOuterTau();
            if (this.outerTauDenom == 0L) {
                this.outerTauNumer = reservoirN;
                this.outerTauDenom = reservoirK;
            } else if (reservoirTau > outerTau) {
                this.outerTauNumer = reservoirN;
                this.outerTauDenom = reservoirK;
            } else if (reservoirTau == outerTau) {
                this.outerTauNumer += (double)reservoirN;
                this.outerTauDenom += (long)reservoirK;
            }
        }
    }

    private VarOptItemsSketch<T> simpleGadgetCoercer() {
        assert (this.gadget_.getNumMarksInH() == 0);
        return this.gadget_.copyAndSetN(true, this.n_);
    }

    private VarOptItemsSketch<T> markMovingGadgetCoercer() {
        int resultK = this.gadget_.getHRegionCount() + this.gadget_.getRRegionCount();
        int resultH = 0;
        int resultR = 0;
        int nextRPos = resultK;
        ArrayList data = new ArrayList(resultK + 1);
        ArrayList<Double> weights = new ArrayList<Double>(resultK + 1);
        for (int i = 0; i < resultK + 1; ++i) {
            data.add(null);
            weights.add(null);
        }
        VarOptItemsSamples<T> sketchSamples = this.gadget_.getSketchSamples();
        Iterator<VarOptItemsSamples.WeightedSample> sketchIterator = sketchSamples.getRIterator();
        while (sketchIterator.hasNext()) {
            VarOptItemsSamples.WeightedSample ws = sketchIterator.next();
            data.set(nextRPos, ws.getItem());
            weights.set(nextRPos, -1.0);
            ++resultR;
            --nextRPos;
        }
        double transferredWeight = 0.0;
        sketchIterator = sketchSamples.getHIterator();
        while (sketchIterator.hasNext()) {
            VarOptItemsSamples.WeightedSample ws = sketchIterator.next();
            if (ws.getMark()) {
                data.set(nextRPos, ws.getItem());
                weights.set(nextRPos, -1.0);
                transferredWeight += ws.getWeight();
                ++resultR;
                --nextRPos;
                continue;
            }
            data.set(resultH, ws.getItem());
            weights.set(resultH, ws.getWeight());
            ++resultH;
        }
        assert (resultH + resultR == resultK);
        assert (Math.abs(transferredWeight - this.outerTauNumer) < 1.0E-10);
        double resultRWeight = this.gadget_.getTotalWtR() + transferredWeight;
        long resultN = this.n_;
        data.set(resultH, null);
        weights.set(resultH, -1.0);
        return VarOptItemsSketch.newInstanceFromUnionResult(data, weights, resultK, resultN, resultH, resultR, resultRWeight);
    }

    private VarOptItemsSketch<T> detectAndHandleSubcaseOfPseudoExact() {
        boolean condition3;
        boolean condition1 = this.gadget_.getRRegionCount() == 0;
        boolean condition2 = this.gadget_.getNumMarksInH() > 0;
        boolean bl = condition3 = (long)this.gadget_.getNumMarksInH() == this.outerTauDenom;
        if (!(condition1 && condition2 && condition3)) {
            return null;
        }
        boolean antiCondition4 = this.thereExistUnmarkedHItemsLighterThanTarget(this.gadget_.getTau());
        if (antiCondition4) {
            return null;
        }
        return this.markMovingGadgetCoercer();
    }

    private boolean thereExistUnmarkedHItemsLighterThanTarget(double threshold) {
        for (int i = 0; i < this.gadget_.getHRegionCount(); ++i) {
            if (!(this.gadget_.getWeight(i) < threshold) || this.gadget_.getMark(i)) continue;
            return true;
        }
        return false;
    }

    private VarOptItemsSketch<T> migrateMarkedItemsByDecreasingK() {
        VarOptItemsSketch<T> gcopy = this.gadget_.copyAndSetN(false, this.n_);
        int rCount = gcopy.getRRegionCount();
        int hCount = gcopy.getHRegionCount();
        int k = gcopy.getK();
        assert (gcopy.getNumMarksInH() > 0);
        assert (rCount == 0 || k == hCount + rCount);
        if (rCount == 0 && hCount < k) {
            gcopy.forceSetK(hCount);
        }
        assert (gcopy.getK() >= 2);
        gcopy.decreaseKBy1();
        assert (gcopy.getRRegionCount() > 0);
        assert (gcopy.getTau() > 0.0);
        while (gcopy.getNumMarksInH() > 0) {
            assert (gcopy.getK() >= 2);
            gcopy.decreaseKBy1();
        }
        gcopy.stripMarks();
        return gcopy;
    }
}

