/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.Util;
import org.apache.datasketches.memory.internal.UtilTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AllocateDirectMapMemoryTest {
    @Test
    public void simpleMap() throws IOException {
        File file = UtilTest.setGettysburgAddressFileToReadOnly();
        Memory mem = null;
        try (Arena arena = Arena.ofConfined();){
            mem = Memory.map((File)file, (Arena)arena);
            arena.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (mem != null) {
            Assert.assertFalse((boolean)mem.isAlive());
        }
    }

    @Test
    public void testIllegalArguments() throws IOException {
        Arena arena2;
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        Memory mem = null;
        try {
            arena2 = Arena.ofConfined();
            try {
                mem = Memory.map((File)file, (long)-1L, (long)Integer.MAX_VALUE, (ByteOrder)ByteOrder.nativeOrder(), (Arena)arena2);
                Assert.fail((String)"Failed: test IllegalArgumentException: Position was negative.");
                mem.getCapacity();
            }
            finally {
                if (arena2 != null) {
                    arena2.close();
                }
            }
        }
        catch (IllegalArgumentException arena2) {
            // empty catch block
        }
        if (mem != null) {
            Assert.assertFalse((boolean)mem.isAlive());
        }
        try {
            arena2 = Arena.ofConfined();
            try {
                mem = Memory.map((File)file, (long)0L, (long)-1L, (ByteOrder)ByteOrder.nativeOrder(), (Arena)arena2);
                Assert.fail((String)"Failed: test IllegalArgumentException: Size was negative.");
            }
            finally {
                if (arena2 != null) {
                    arena2.close();
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (mem != null) {
            Assert.assertFalse((boolean)mem.isAlive());
        }
    }

    @Test
    public void testMapAndMultipleClose() throws IOException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        Memory mem = null;
        Memory mem2 = null;
        try (Arena arena = Arena.ofConfined();){
            mem2 = mem = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder(), (Arena)arena);
            Assert.assertEquals((long)memCapacity, (long)mem.getCapacity());
            arena.close();
            Assert.assertFalse((boolean)mem.isAlive());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (mem != null) {
            Assert.assertFalse((boolean)mem.isAlive());
        }
        if (mem2 != null) {
            Assert.assertFalse((boolean)mem2.isAlive());
        }
    }

    @Test
    public void testLoad() throws IOException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        try (Arena arena = Arena.ofConfined();){
            Memory mem = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder(), (Arena)arena);
            mem.load();
            Assert.assertTrue((boolean)mem.isAlive());
        }
    }

    @Test
    public void printlnTest() {
        AllocateDirectMapMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (o == null) {
            AllocateDirectMapMemoryTest.print(ResourceImpl.LS);
        } else {
            AllocateDirectMapMemoryTest.print(o.toString() + ResourceImpl.LS);
        }
    }

    static void print(Object o) {
        if (o != null) {
            // empty if block
        }
    }
}

