/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core;

import org.apache.directory.fortress.core.ConfigMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.ConfigMgrImpl;
import org.apache.directory.fortress.core.rest.ConfigMgrRestImpl;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;

public final class ConfigMgrFactory {
    public static final String ENABLE_REST = "enable.mgr.impl.rest";

    private ConfigMgrFactory() {
    }

    public static ConfigMgr createInstance() throws SecurityException {
        String configClassName = Config.getInstance().getProperty("configmgr.implementation");
        boolean IS_REST = Config.getInstance().getProperty(ENABLE_REST) != null && Config.getInstance().getProperty(ENABLE_REST).equalsIgnoreCase("true");
        return ConfigMgrFactory.createInstance(configClassName, IS_REST);
    }

    public static ConfigMgr createInstance(String configClassName, boolean IS_REST) throws SecurityException {
        if (configClassName == null || configClassName.compareTo("") == 0) {
            configClassName = Config.getInstance().isRestEnabled() ? ConfigMgrRestImpl.class.getName() : ConfigMgrImpl.class.getName();
        }
        return (ConfigMgr)ClassUtil.createInstance(configClassName);
    }
}

