/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.fortress.core.CreateException;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.RemoveException;
import org.apache.directory.fortress.core.UpdateException;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.PwPolicy;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.ldap.client.api.LdapConnection;

final class PolicyDAO
extends LdapDataProvider {
    private static final String OLPW_POLICY_EXTENSION = "2.5.4.35";
    private static final String PW_POLICY_EXTENSION;
    private static final String ADS_BASE_CLASS = "ads-base";
    private static final String PW_POLICY_CLASS;
    private static String[] PWPOLICY_OBJ_CLASS;
    private static final String PW_PWD_ID;
    private static final String PW_MIN_AGE;
    private static final String PW_MAX_AGE;
    private static final String PW_IN_HISTORY;
    private static final String PW_CHECK_QUALITY;
    private static final String PW_MIN_LENGTH;
    private static final String PW_EXPIRE_WARNING;
    private static final String PW_GRACE_LOGIN_LIMIT;
    private static final String PW_LOCKOUT;
    private static final String PW_LOCKOUT_DURATION;
    private static final String PW_MAX_FAILURE;
    private static final String PW_FAILURE_COUNT_INTERVAL;
    private static final String PW_MUST_CHANGE;
    private static final String PW_ALLOW_USER_CHANGE;
    private static final String PW_SAFE_MODIFY;
    private static final String PW_ATTRIBUTE;
    private static final String[] PASSWORD_POLICY_ATRS;
    private static final String[] PASSWORD_POLICY_NAME_ATR;

    PolicyDAO() {
    }

    PwPolicy create(PwPolicy entity) throws CreateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity);
        try {
            DefaultEntry entry = new DefaultEntry(dn);
            entry.add("objectClass", PWPOLICY_OBJ_CLASS);
            entry.add(PW_PWD_ID, new String[]{entity.getName()});
            entry.add(PW_ATTRIBUTE, new String[]{PW_POLICY_EXTENSION});
            if (entity.getMinAge() != null) {
                entry.add(PW_MIN_AGE, new String[]{entity.getMinAge().toString()});
            }
            if (entity.getMaxAge() != null) {
                entry.add(PW_MAX_AGE, new String[]{entity.getMaxAge().toString()});
            }
            if (entity.getInHistory() != null) {
                entry.add(PW_IN_HISTORY, new String[]{entity.getInHistory().toString()});
            }
            if (entity.getCheckQuality() != null) {
                entry.add(PW_CHECK_QUALITY, new String[]{entity.getCheckQuality().toString()});
            }
            if (entity.getMinLength() != null) {
                entry.add(PW_MIN_LENGTH, new String[]{entity.getMinLength().toString()});
            }
            if (entity.getExpireWarning() != null) {
                entry.add(PW_EXPIRE_WARNING, new String[]{entity.getExpireWarning().toString()});
            }
            if (entity.getGraceLoginLimit() != null) {
                entry.add(PW_GRACE_LOGIN_LIMIT, new String[]{entity.getGraceLoginLimit().toString()});
            }
            if (entity.getLockout() != null) {
                entry.add(PW_LOCKOUT, new String[]{entity.getLockout().toString().toUpperCase()});
            }
            if (entity.getLockoutDuration() != null) {
                entry.add(PW_LOCKOUT_DURATION, new String[]{entity.getLockoutDuration().toString()});
            }
            if (entity.getMaxFailure() != null) {
                entry.add(PW_MAX_FAILURE, new String[]{entity.getMaxFailure().toString()});
            }
            if (entity.getFailureCountInterval() != null) {
                entry.add(PW_FAILURE_COUNT_INTERVAL, new String[]{entity.getFailureCountInterval().toString()});
            }
            if (entity.getMustChange() != null) {
                entry.add(PW_MUST_CHANGE, new String[]{entity.getMustChange().toString().toUpperCase()});
            }
            if (entity.getAllowUserChange() != null) {
                entry.add(PW_ALLOW_USER_CHANGE, new String[]{entity.getAllowUserChange().toString().toUpperCase()});
            }
            if (entity.getSafeModify() != null) {
                entry.add(PW_SAFE_MODIFY, new String[]{entity.getSafeModify().toString().toUpperCase()});
            }
            ld = this.getAdminConnection();
            this.add(ld, (Entry)entry, entity);
        }
        catch (LdapException e) {
            try {
                String error = "create name [" + entity.getName() + "] caught LdapException=" + e;
                throw new CreateException(4001, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    void update(PwPolicy entity) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity);
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (entity.getMinAge() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_MIN_AGE, new String[]{entity.getMinAge().toString()}));
            }
            if (entity.getMaxAge() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_MAX_AGE, new String[]{entity.getMaxAge().toString()}));
            }
            if (entity.getInHistory() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_IN_HISTORY, new String[]{entity.getInHistory().toString()}));
            }
            if (entity.getCheckQuality() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_CHECK_QUALITY, new String[]{entity.getCheckQuality().toString()}));
            }
            if (entity.getMinLength() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_MIN_LENGTH, new String[]{entity.getMinLength().toString()}));
            }
            if (entity.getExpireWarning() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_EXPIRE_WARNING, new String[]{entity.getExpireWarning().toString()}));
            }
            if (entity.getGraceLoginLimit() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_GRACE_LOGIN_LIMIT, new String[]{entity.getGraceLoginLimit().toString()}));
            }
            if (entity.getLockout() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_LOCKOUT, new String[]{entity.getLockout().toString().toUpperCase()}));
            }
            if (entity.getLockoutDuration() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_LOCKOUT_DURATION, new String[]{entity.getLockoutDuration().toString()}));
            }
            if (entity.getMaxFailure() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_MAX_FAILURE, new String[]{entity.getMaxFailure().toString()}));
            }
            if (entity.getFailureCountInterval() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_FAILURE_COUNT_INTERVAL, new String[]{entity.getFailureCountInterval().toString()}));
            }
            if (entity.getMustChange() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_MUST_CHANGE, new String[]{entity.getMustChange().toString().toUpperCase()}));
            }
            if (entity.getAllowUserChange() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_ALLOW_USER_CHANGE, new String[]{entity.getAllowUserChange().toString().toUpperCase()}));
            }
            if (entity.getSafeModify() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PW_SAFE_MODIFY, new String[]{entity.getSafeModify().toString().toUpperCase()}));
            }
            if (mods != null && mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, dn, mods, (FortEntity)entity);
            }
        }
        catch (LdapException e) {
            String error = "update name [" + entity.getName() + "] caught LdapException=" + e;
            throw new UpdateException(4002, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    void remove(PwPolicy entity) throws RemoveException {
        LdapConnection ld = null;
        String dn = this.getDn(entity);
        try {
            ld = this.getAdminConnection();
            this.delete(ld, dn, (FortEntity)entity);
        }
        catch (LdapException e) {
            String error = "remove name [" + entity.getName() + "] caught LdapException=" + e;
            throw new RemoveException(4003, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    PwPolicy getPolicy(PwPolicy policy) throws FinderException {
        PwPolicy entity = null;
        LdapConnection ld = null;
        String dn = this.getDn(policy);
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, dn, PASSWORD_POLICY_ATRS);
            entity = this.unloadLdapEntry(findEntry, 0L);
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getPolicy Obj COULD NOT FIND ENTRY for dn [" + dn + "]";
            throw new FinderException(4005, warning);
        }
        catch (LdapException e) {
            String error = "getPolicy name [" + policy.getName() + "] caught LdapException=" + e;
            throw new FinderException(4000, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return entity;
    }

    private PwPolicy unloadLdapEntry(Entry le, long sequence) throws LdapInvalidAttributeValueException {
        PwPolicy entity = new ObjectFactory().createPswdPolicy();
        entity.setSequenceId(sequence);
        entity.setName(this.getAttribute(le, PW_PWD_ID));
        String val = this.getAttribute(le, PW_MIN_AGE);
        if (StringUtils.isNotEmpty((String)val)) {
            entity.setMinAge(Integer.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_MAX_AGE)))) {
            entity.setMaxAge(Long.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_IN_HISTORY)))) {
            entity.setInHistory(Short.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_CHECK_QUALITY)))) {
            entity.setCheckQuality(Short.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_MIN_LENGTH)))) {
            entity.setMinLength(Short.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_EXPIRE_WARNING)))) {
            entity.setExpireWarning(Long.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_GRACE_LOGIN_LIMIT)))) {
            entity.setGraceLoginLimit(Short.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_LOCKOUT)))) {
            entity.setLockout(Boolean.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_LOCKOUT_DURATION)))) {
            entity.setLockoutDuration(Integer.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_MAX_FAILURE)))) {
            entity.setMaxFailure(Short.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_FAILURE_COUNT_INTERVAL)))) {
            entity.setFailureCountInterval(Short.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_MUST_CHANGE)))) {
            entity.setMustChange(Boolean.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_ALLOW_USER_CHANGE)))) {
            entity.setAllowUserChange(Boolean.valueOf(val));
        }
        if (StringUtils.isNotEmpty((String)(val = this.getAttribute(le, PW_SAFE_MODIFY)))) {
            entity.setSafeModify(Boolean.valueOf(val));
        }
        return entity;
    }

    List<PwPolicy> findPolicy(PwPolicy policy) throws FinderException {
        ArrayList<PwPolicy> policyArrayList = new ArrayList<PwPolicy>();
        LdapConnection ld = null;
        String policyRoot = PolicyDAO.getPolicyRoot(policy.getContextId());
        String searchVal = null;
        try {
            searchVal = this.encodeSafeText(policy.getName(), 40);
            String szFilter = "(&(objectClass=" + PW_POLICY_CLASS + ")(" + PW_PWD_ID + "=" + searchVal + "*))";
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, policyRoot, SearchScope.ONELEVEL, szFilter, PASSWORD_POLICY_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    policyArrayList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++));
                }
            }
            catch (IOException e) {
                String error = "findPolicy name [" + searchVal + "] caught IOException=" + e.getMessage();
                throw new FinderException(4004, error, e);
            }
            catch (CursorException e) {
                String error = "findPolicy name [" + searchVal + "] caught CursorException=" + e.getMessage();
                throw new FinderException(4004, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findPolicy name [" + searchVal + "] caught LdapException=" + e;
                throw new FinderException(4004, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return policyArrayList;
    }

    Set<String> getPolicies(String contextId) throws FinderException {
        TreeSet<String> policySet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        LdapConnection ld = null;
        String policyRoot = PolicyDAO.getPolicyRoot(contextId);
        try {
            String szFilter = "(objectclass=" + PW_POLICY_CLASS + ")";
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, policyRoot, SearchScope.ONELEVEL, szFilter, PASSWORD_POLICY_NAME_ATR, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                while (searchResults.next()) {
                    Entry entry = searchResults.getEntry();
                    policySet.add(this.getAttribute(entry, PW_PWD_ID));
                }
            }
            catch (IOException e) {
                String error = "getPolicies caught IOException=" + e.getMessage();
                throw new FinderException(4004, error, e);
            }
            catch (CursorException e) {
                String error = "getPolicies caught CursorException=" + e.getMessage();
                throw new FinderException(4004, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String error = "getPolicies caught LdapException=" + e;
                throw new FinderException(4004, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return policySet;
    }

    private String getDn(PwPolicy policy) {
        return PW_PWD_ID + "=" + policy.getName() + "," + PolicyDAO.getPolicyRoot(policy.getContextId());
    }

    static String getPolicyDn(User user) {
        return PW_PWD_ID + "=" + user.getPwPolicy() + "," + PolicyDAO.getPolicyRoot(user.getContextId());
    }

    private static String getPolicyRoot(String contextId) {
        String szDn = Config.getInstance().isApacheds() ? PolicyDAO.getRootDn(contextId, "apacheds.pwpolicy.root") : PolicyDAO.getRootDn(contextId, "pwpolicy.root");
        return szDn;
    }

    static {
        String[] stringArray;
        PW_POLICY_EXTENSION = Config.getInstance().isOpenldap() ? OLPW_POLICY_EXTENSION : "userPassword";
        String string = PW_POLICY_CLASS = Config.getInstance().isOpenldap() ? "pwdPolicy" : "ads-passwordPolicy";
        if (Config.getInstance().isOpenldap()) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "top";
            stringArray2[1] = "device";
            stringArray2[2] = PW_POLICY_CLASS;
            stringArray = stringArray2;
            stringArray2[3] = "ftMods";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "top";
            stringArray3[1] = ADS_BASE_CLASS;
            stringArray3[2] = PW_POLICY_CLASS;
            stringArray = stringArray3;
            stringArray3[3] = "ftMods";
        }
        PWPOLICY_OBJ_CLASS = stringArray;
        PW_PWD_ID = Config.getInstance().isOpenldap() ? "cn" : "ads-pwdid";
        PW_MIN_AGE = Config.getInstance().isOpenldap() ? "pwdMinAge" : "ads-pwdMinAge";
        PW_MAX_AGE = Config.getInstance().isOpenldap() ? "pwdMaxAge" : "ads-pwdMaxAge";
        PW_IN_HISTORY = Config.getInstance().isOpenldap() ? "pwdInHistory" : "ads-pwdInHistory";
        PW_CHECK_QUALITY = Config.getInstance().isOpenldap() ? "pwdCheckQuality" : "ads-pwdCheckQuality";
        PW_MIN_LENGTH = Config.getInstance().isOpenldap() ? "pwdMinLength" : "ads-pwdMinLength";
        PW_EXPIRE_WARNING = Config.getInstance().isOpenldap() ? "pwdExpireWarning" : "ads-pwdExpireWarning";
        PW_GRACE_LOGIN_LIMIT = Config.getInstance().isOpenldap() ? "pwdGraceAuthNLimit" : "ads-pwdGraceAuthNLimit";
        PW_LOCKOUT = Config.getInstance().isOpenldap() ? "pwdLockout" : "ads-pwdLockout";
        PW_LOCKOUT_DURATION = Config.getInstance().isOpenldap() ? "pwdLockoutDuration" : "ads-pwdLockoutDuration";
        PW_MAX_FAILURE = Config.getInstance().isOpenldap() ? "pwdMaxFailure" : "ads-pwdMaxFailure";
        PW_FAILURE_COUNT_INTERVAL = Config.getInstance().isOpenldap() ? "pwdFailureCountInterval" : "ads-pwdFailureCountInterval";
        PW_MUST_CHANGE = Config.getInstance().isOpenldap() ? "pwdMustChange" : "ads-pwdMustChange";
        PW_ALLOW_USER_CHANGE = Config.getInstance().isOpenldap() ? "pwdAllowUserChange" : "ads-pwdAllowUserChange";
        PW_SAFE_MODIFY = Config.getInstance().isOpenldap() ? "pwdSafeModify" : "ads-pwdSafeModify";
        PW_ATTRIBUTE = Config.getInstance().isOpenldap() ? "pwdAttribute" : "ads-pwdAttribute";
        PASSWORD_POLICY_ATRS = new String[]{PW_PWD_ID, PW_MIN_AGE, PW_MAX_AGE, PW_IN_HISTORY, PW_CHECK_QUALITY, PW_MIN_LENGTH, PW_EXPIRE_WARNING, PW_GRACE_LOGIN_LIMIT, PW_LOCKOUT, PW_LOCKOUT_DURATION, PW_MAX_FAILURE, PW_FAILURE_COUNT_INTERVAL, PW_MUST_CHANGE, PW_ALLOW_USER_CHANGE, PW_SAFE_MODIFY};
        PASSWORD_POLICY_NAME_ATR = new String[]{PW_PWD_ID};
    }
}

