/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.model.Administrator;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.Role;

@XmlRootElement(name="fortAdminRole")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="adminRole", propOrder={"osPs", "osUs", "beginRange", "endRange", "beginInclusive", "endInclusive"})
public class AdminRole
extends Role
implements Administrator {
    private static final long serialVersionUID = 1L;
    private Set<String> osPs;
    private Set<String> osUs;
    private String beginRange;
    private String endRange;
    private boolean beginInclusive;
    private boolean endInclusive;

    public AdminRole() {
    }

    public AdminRole(Constraint con) {
        ConstraintUtil.copy(con, this);
    }

    public AdminRole(String name) {
        this.setName(name);
    }

    @Override
    public void setRoleRangeRaw(String szRaw) {
        if (StringUtils.isNotEmpty((String)szRaw)) {
            int bindx = szRaw.indexOf(40);
            if (bindx > -1) {
                this.setBeginInclusive(false);
            } else {
                bindx = szRaw.indexOf(91);
                this.setBeginInclusive(true);
            }
            int eindx = szRaw.indexOf(41);
            if (eindx > -1) {
                this.setEndInclusive(false);
            } else {
                eindx = szRaw.indexOf(93);
                this.setEndInclusive(true);
            }
            int cindx = szRaw.indexOf(58);
            if (cindx > -1) {
                String szBeginRange = szRaw.substring(bindx + 1, cindx);
                String szEndRange = szRaw.substring(cindx + 1, eindx);
                this.setBeginRange(szBeginRange);
                this.setEndRange(szEndRange);
            }
        }
    }

    @Override
    public String getRoleRangeRaw() {
        Object szRaw = "";
        if (this.beginRange != null) {
            szRaw = this.isBeginInclusive() ? (String)szRaw + "[" : (String)szRaw + "(";
            szRaw = (String)szRaw + this.getBeginRange();
            szRaw = (String)szRaw + ":";
            szRaw = (String)szRaw + this.getEndRange();
            szRaw = this.isEndInclusive() ? (String)szRaw + "]" : (String)szRaw + ")";
        }
        return szRaw;
    }

    @Override
    public Set<String> getOsPSet() {
        return this.osPs;
    }

    @Override
    public void setOsPSet(Set<String> osPs) {
        this.osPs = osPs;
    }

    @Override
    public void setOsP(String osP) {
        if (this.osPs == null) {
            this.osPs = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.osPs.add(osP);
    }

    @Override
    public Set<String> getOsUSet() {
        return this.osUs;
    }

    @Override
    public void setOsUSet(Set<String> osUs) {
        this.osUs = osUs;
    }

    @Override
    public void setOsU(String osU) {
        if (this.osUs == null) {
            this.osUs = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.osUs.add(osU);
    }

    @Override
    public String getBeginRange() {
        return this.beginRange;
    }

    @Override
    public void setBeginRange(String beginRange) {
        this.beginRange = beginRange;
    }

    @Override
    public String getEndRange() {
        return this.endRange;
    }

    @Override
    public void setEndRange(String endRange) {
        this.endRange = endRange;
    }

    @Override
    public boolean isBeginInclusive() {
        return this.beginInclusive;
    }

    @Override
    public void setBeginInclusive(boolean beginInclusive) {
        this.beginInclusive = beginInclusive;
    }

    @Override
    public boolean isEndInclusive() {
        return this.endInclusive;
    }

    @Override
    public void setEndInclusive(boolean endInclusive) {
        this.endInclusive = endInclusive;
    }

    @Override
    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (this.getName() == null) {
            return false;
        }
        if (!(thatObj instanceof AdminRole)) {
            return false;
        }
        Role thatRole = (Role)thatObj;
        if (thatRole.getName() == null) {
            return false;
        }
        return thatRole.getName().equalsIgnoreCase(this.getName());
    }

    @Override
    public int hashCode() {
        int result = this.osPs != null ? this.osPs.hashCode() : 0;
        result = 31 * result + (this.osUs != null ? this.osUs.hashCode() : 0);
        result = 31 * result + (this.beginRange != null ? this.beginRange.hashCode() : 0);
        result = 31 * result + (this.endRange != null ? this.endRange.hashCode() : 0);
        result = 31 * result + (this.beginInclusive ? 1 : 0);
        result = 31 * result + (this.endInclusive ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        boolean isFirst;
        StringBuilder sb = new StringBuilder();
        sb.append("AdminRole object: \n");
        sb.append(super.toString("    ")).append('\n');
        if (this.beginRange != null) {
            sb.append("    beginRange :").append(this.beginRange).append('\n');
        }
        if (this.endRange != null) {
            sb.append("    endRange :").append(this.endRange).append('\n');
        }
        sb.append("    beginInclusive :").append(this.beginInclusive).append('\n');
        sb.append("    endInclusive :").append(this.endInclusive).append('\n');
        if (this.osPs != null) {
            sb.append("    osPs : ");
            isFirst = true;
            for (String osP : this.osPs) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(osP);
            }
            sb.append('\n');
        }
        if (this.osUs != null) {
            sb.append("    osUs : ");
            isFirst = true;
            for (String osU : this.osUs) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(osU);
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

