/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.dialogs.RenameEntryDialog;
import org.apache.directory.studio.ldapbrowser.common.dialogs.SimulateRenameDialogImpl;
import org.apache.directory.studio.ldapbrowser.core.jobs.RenameEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SimulateRenameDialog;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.Messages;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RenameValueEditor
extends CellEditor
implements IValueEditor {
    private Object value;
    private Composite parent;
    private String name;
    private ImageDescriptor imageDescriptor;
    protected ValueEditorManager valueEditorManager;

    public RenameValueEditor(Composite parent, ValueEditorManager valueEditorManager) {
        super(parent);
        this.parent = parent;
        this.valueEditorManager = valueEditorManager;
    }

    protected Control createControl(Composite parent) {
        return null;
    }

    protected final Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
    }

    protected void doSetValue(Object value) {
        this.value = value;
    }

    public void activate() {
        if (this.getValue() instanceof IEntry) {
            Rdn newRdn;
            IEntry entry = (IEntry)this.getValue();
            RenameEntryDialog renameDialog = new RenameEntryDialog(this.parent.getShell(), entry);
            if (renameDialog.open() == 0 && (newRdn = renameDialog.getRdn()) != null && !newRdn.equals((Object)entry.getRdn())) {
                IEntry originalEntry = entry.getBrowserConnection().getEntryFromCache(entry.getDn());
                new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new RenameEntryRunnable(originalEntry, newRdn, (SimulateRenameDialog)new SimulateRenameDialogImpl(this.parent.getShell()))}).execute();
            }
        }
        this.fireCancelEditor();
    }

    @Override
    public CellEditor getCellEditor() {
        return this;
    }

    @Override
    public String getDisplayValue(AttributeHierarchy attributeHierarchy) {
        ArrayList<IValue> valueList = new ArrayList<IValue>();
        for (IAttribute attribute : attributeHierarchy) {
            valueList.addAll(Arrays.asList(attribute.getValues()));
        }
        StringBuffer sb = new StringBuffer();
        if (valueList.size() > 1) {
            sb.append(NLS.bind((String)Messages.getString("EntryValueEditor.n_values"), (Object)valueList.size()));
        }
        boolean isFirst = true;
        for (IValue value : valueList) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            IValueEditor vp = this.getValueEditor(value);
            sb.append(vp.getDisplayValue(value));
        }
        return sb.toString();
    }

    @Override
    public String getDisplayValue(IValue value) {
        IValueEditor vp = this.getValueEditor(value);
        return vp.getDisplayValue(value);
    }

    private IValueEditor getValueEditor(IValue value) {
        IValueEditor vp = this.valueEditorManager.getCurrentValueEditor(value.getAttribute().getEntry(), value.getAttribute().getDescription());
        if (vp instanceof RenameValueEditor) {
            IValueEditor userSelectedValueEditor = this.valueEditorManager.getUserSelectedValueEditor();
            this.valueEditorManager.setUserSelectedValueEditor(null);
            vp = this.valueEditorManager.getCurrentValueEditor(value.getAttribute().getEntry(), value.getAttribute().getDescription());
            this.valueEditorManager.setUserSelectedValueEditor(userSelectedValueEditor);
        }
        return vp;
    }

    @Override
    public Object getRawValue(AttributeHierarchy attributeHierarchy) {
        return attributeHierarchy.getEntry();
    }

    @Override
    public boolean hasValue(IValue value) {
        return value.getAttribute().getEntry() != null;
    }

    @Override
    public Object getRawValue(IValue value) {
        return value.getAttribute().getEntry();
    }

    @Override
    public Object getStringOrBinaryValue(Object rawValue) {
        return null;
    }

    @Override
    public void setValueEditorName(String name) {
        this.name = name;
    }

    @Override
    public String getValueEditorName() {
        return this.name;
    }

    @Override
    public void setValueEditorImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    @Override
    public ImageDescriptor getValueEditorImageDescriptor() {
        return this.imageDescriptor;
    }
}

