/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import java.util.Arrays;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.AbstractOpenEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorActionGroup;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorCursor;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;

public class OpenEditorAction
extends AbstractOpenEditorAction {
    private IValueEditor valueEditor;

    public OpenEditorAction(TableViewer viewer, SearchResultEditorCursor cursor, ValueEditorManager valueEditorManager, IValueEditor valueEditor, SearchResultEditorActionGroup actionGroup) {
        super(viewer, cursor, valueEditorManager, actionGroup);
        this.cellEditor = valueEditor.getCellEditor();
        this.valueEditor = valueEditor;
    }

    public IValueEditor getValueEditor() {
        return this.valueEditor;
    }

    @Override
    public void run() {
        this.valueEditorManager.setUserSelectedValueEditor(this.valueEditor);
        super.run();
    }

    public void dispose() {
        this.valueEditor = null;
        super.dispose();
    }

    public String getCommandId() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.valueEditor.getValueEditorImageDescriptor();
    }

    public String getText() {
        return this.valueEditor.getValueEditorName();
    }

    public boolean isEnabled() {
        if (this.getSelectedSearchResults().length == 1 && this.getSelectedProperties().length == 1 && this.viewer.getCellModifier().canModify((Object)this.getSelectedSearchResults()[0], this.getSelectedProperties()[0])) {
            if (this.getSelectedAttributeHierarchies().length == 0) {
                return false;
            }
            AttributeHierarchy ah = this.getSelectedAttributeHierarchies()[0];
            IValueEditor[] alternativeVps = this.valueEditorManager.getAlternativeValueEditors(ah);
            return Arrays.asList(alternativeVps).contains(this.valueEditor) && this.valueEditor.getRawValue(ah) != null;
        }
        return false;
    }
}

