/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.views;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.studio.ldapservers.LdapServersManager;
import org.apache.directory.studio.ldapservers.LdapServersManagerListener;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerEvent;
import org.apache.directory.studio.ldapservers.model.LdapServerEventType;
import org.apache.directory.studio.ldapservers.model.LdapServerListener;
import org.apache.directory.studio.ldapservers.model.LdapServerStatus;
import org.apache.directory.studio.ldapservers.views.ServersViewContentProvider;
import org.apache.directory.studio.ldapservers.views.ServersViewLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ServersTableViewer
extends TreeViewer {
    protected static final String ROOT = "root";
    private ServersViewLabelProvider labelProvider;
    private ServersComparator comparator;
    private LdapServersManagerListener serversHandlerListener;
    private LdapServerListener serverListener;
    private boolean stopAnimation;
    private List<LdapServer> serversNeedingAnimation = new ArrayList<LdapServer>();

    public ServersTableViewer(Tree tree) {
        super(tree);
        this.labelProvider = new ServersViewLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setContentProvider((IContentProvider)new ServersViewContentProvider());
        this.comparator = new ServersComparator();
        this.setComparator(new ViewerComparator((Comparator)this.comparator));
        this.setInput(ROOT);
        this.addListeners();
    }

    private void addListeners() {
        this.serversHandlerListener = new LdapServersManagerListener(){

            @Override
            public void serverAdded(LdapServer server) {
                ServersTableViewer.this.addServer(server);
                server.addListener(ServersTableViewer.this.serverListener);
            }

            @Override
            public void serverRemoved(LdapServer server) {
                ServersTableViewer.this.refreshServer(server);
            }

            @Override
            public void serverUpdated(LdapServer server) {
                ServersTableViewer.this.removeServer(server);
                server.removeListener(ServersTableViewer.this.serverListener);
            }
        };
        LdapServersManager.getDefault().addListener(this.serversHandlerListener);
        this.serverListener = new LdapServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serverChanged(LdapServerEvent event) {
                if (event == null) {
                    return;
                }
                LdapServerEventType kind = event.getKind();
                LdapServer server = event.getServer();
                switch (kind) {
                    case STATUS_CHANGED: {
                        ServersTableViewer.this.refreshServer(server);
                        LdapServerStatus state = server.getStatus();
                        if (state == LdapServerStatus.STARTING || state == LdapServerStatus.STOPPING || state == LdapServerStatus.REPAIRING) {
                            boolean startAnimationThread = false;
                            List list = ServersTableViewer.this.serversNeedingAnimation;
                            synchronized (list) {
                                if (!ServersTableViewer.this.serversNeedingAnimation.contains(server)) {
                                    if (ServersTableViewer.this.serversNeedingAnimation.isEmpty()) {
                                        startAnimationThread = true;
                                    }
                                    ServersTableViewer.this.serversNeedingAnimation.add(server);
                                }
                            }
                            if (!startAnimationThread) break;
                            ServersTableViewer.this.startAnimationThread();
                            break;
                        }
                        boolean stopAnimationThread = false;
                        List list = ServersTableViewer.this.serversNeedingAnimation;
                        synchronized (list) {
                            if (ServersTableViewer.this.serversNeedingAnimation.contains(server)) {
                                ServersTableViewer.this.serversNeedingAnimation.remove(server);
                                if (ServersTableViewer.this.serversNeedingAnimation.isEmpty()) {
                                    stopAnimationThread = true;
                                }
                            }
                        }
                        if (!stopAnimationThread) break;
                        ServersTableViewer.this.stopAnimationThread();
                        break;
                    }
                    case RENAMED: {
                        ServersTableViewer.this.refreshServer(server);
                    }
                }
            }
        };
        for (LdapServer server : LdapServersManager.getDefault().getServersList()) {
            server.addListener(this.serverListener);
        }
    }

    private void addServer(final LdapServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ServersTableViewer.this.add(ServersTableViewer.ROOT, server);
            }
        });
    }

    private void refreshServer(final LdapServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ServersTableViewer.this.refresh(server);
                ISelection sel = ServersTableViewer.this.getSelection();
                ServersTableViewer.this.setSelection(sel);
            }
        });
    }

    private void removeServer(final LdapServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ServersTableViewer.this.remove(server);
            }
        });
    }

    private void startAnimationThread() {
        Runnable[] animatorThread;
        this.stopAnimation = false;
        final Display display = this.getTree().getDisplay();
        animatorThread = new Runnable[]{new Runnable(){

            @Override
            public void run() {
                if (!ServersTableViewer.this.stopAnimation) {
                    ServersTableViewer.this.labelProvider.animate();
                    LdapServer[] ldapServerArray = ServersTableViewer.this.serversNeedingAnimation.toArray(new LdapServer[0]);
                    int n = ldapServerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LdapServer server = ldapServerArray[n2];
                        if (server != null && ServersTableViewer.this.getTree() != null && !ServersTableViewer.this.getTree().isDisposed()) {
                            ServersTableViewer.this.updateAnimation(server);
                        }
                        ++n2;
                    }
                    display.timerExec(200, animatorThread[0]);
                }
            }
        }};
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                display.timerExec(200, animatorThread[0]);
            }
        });
    }

    private void stopAnimationThread() {
        this.stopAnimation = true;
    }

    private void updateAnimation(LdapServer server) {
        Widget widget = this.doFindItem(server);
        TreeItem item = (TreeItem)widget;
        item.setText(1, this.labelProvider.getColumnText(server, 1));
        item.setImage(1, this.labelProvider.getColumnImage(server, 1));
    }

    public void sort(final TreeColumn treeColumn, int column) {
        if (column == this.comparator.column) {
            this.comparator.reverseOrdering();
        } else {
            this.comparator.column = column;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ServersTableViewer.this.refresh();
                Tree tree = ServersTableViewer.this.getTree();
                tree.setSortColumn(treeColumn);
                if (((ServersTableViewer)ServersTableViewer.this).comparator.order == 1) {
                    tree.setSortDirection(128);
                } else {
                    tree.setSortDirection(1024);
                }
            }
        });
    }

    private class ServersComparator
    implements Comparator<Object> {
        public static final int ASCENDING = 1;
        int order = 1;
        int column = 0;

        private ServersComparator() {
        }

        public void reverseOrdering() {
            this.order *= -1;
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = ServersTableViewer.this.labelProvider.getColumnText(o1, this.column);
            String s2 = ServersTableViewer.this.labelProvider.getColumnText(o2, this.column);
            return s1.compareToIgnoreCase(s2) * this.order;
        }
    }
}

