/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.io.FilePermission;
import javax.servlet.Servlet;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.util.ServiceUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class WhiteboardServletHandler
extends ServletHandler {
    private final BundleContext bundleContext;
    private final int multipartErrorCode;
    private final Bundle multipartSecurityContext;

    public WhiteboardServletHandler(long contextServiceId, ExtServletContext context, ServletInfo servletInfo, BundleContext contextBundleContext, Bundle registeringBundle, Bundle httpWhiteboardBundle) {
        super(contextServiceId, context, servletInfo);
        this.bundleContext = contextBundleContext;
        int errorCode = -1;
        if (this.getMultipartConfig() != null && System.getSecurityManager() != null) {
            FilePermission writePerm = new FilePermission(this.getMultipartConfig().multipartLocation, "read,write,delete");
            if (servletInfo.getMultipartConfig().multipartLocation == null) {
                this.multipartSecurityContext = httpWhiteboardBundle;
                if (!httpWhiteboardBundle.hasPermission((Object)writePerm)) {
                    errorCode = 9;
                } else {
                    FilePermission readPerm = new FilePermission(this.getMultipartConfig().multipartLocation, "read");
                    if (!registeringBundle.hasPermission((Object)readPerm)) {
                        errorCode = 10;
                    }
                }
            } else {
                this.multipartSecurityContext = registeringBundle;
                if (!registeringBundle.hasPermission((Object)writePerm)) {
                    errorCode = 8;
                }
                if (!httpWhiteboardBundle.hasPermission((Object)writePerm)) {
                    errorCode = 11;
                }
            }
        } else {
            this.multipartSecurityContext = null;
        }
        this.multipartErrorCode = errorCode;
    }

    @Override
    public int init() {
        if (this.multipartErrorCode != -1) {
            return this.multipartErrorCode;
        }
        if (this.useCount > 0) {
            ++this.useCount;
            return -1;
        }
        ServiceReference serviceReference = this.getServletInfo().getServiceReference();
        this.setServlet((Servlet)ServiceUtils.safeGetServiceObjects(this.bundleContext, serviceReference));
        int reason = super.init();
        if (reason != -1) {
            ServiceUtils.safeUngetServiceObjects(this.bundleContext, serviceReference, this.getServlet());
            this.setServlet(null);
        }
        return reason;
    }

    @Override
    public boolean destroy() {
        Servlet s = this.getServlet();
        if (s != null && super.destroy()) {
            ServiceUtils.safeUngetServiceObjects(this.bundleContext, this.getServletInfo().getServiceReference(), s);
            return true;
        }
        return false;
    }

    @Override
    public Bundle getMultipartSecurityContext() {
        return this.multipartSecurityContext;
    }
}

