/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.felix.http.base.internal.runtime.AbstractInfo;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.apache.felix.http.base.internal.util.PatternUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.ServiceReference;
import org.osgi.service.servlet.context.ServletContextHelper;

public class ServletContextHelperInfo
extends AbstractInfo<ServletContextHelper> {
    private final String name;
    private final String path;
    private final Map<String, String> initParams;

    public ServletContextHelperInfo(ServiceReference<ServletContextHelper> ref) {
        super(ref);
        this.name = this.getStringProperty(ref, "osgi.http.whiteboard.context.name");
        this.path = this.getStringProperty(ref, "osgi.http.whiteboard.context.path");
        this.initParams = this.getInitParams(ref, "context.init.");
    }

    public ServletContextHelperInfo(int serviceRanking, long serviceId, String name, String path, Map<String, String> initParams) {
        super(serviceRanking, serviceId);
        this.name = name;
        this.path = path;
        this.initParams = initParams == null ? Collections.emptyMap() : Collections.unmodifiableMap(initParams);
    }

    private boolean isValidPath() {
        if (!this.isEmpty(this.path)) {
            if (this.path.equals("/")) {
                return true;
            }
            if (this.path.startsWith("/") && !this.path.endsWith("/")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && PatternUtil.isValidSymbolicName(this.name) && !"org.osgi.service.http".equals(this.name) && this.isValidPath();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getInitParameters() {
        return this.initParams;
    }

    @Override
    @NotNull
    public String getType() {
        return "ServletContextHelper";
    }

    @NotNull
    public String getServiceType() {
        return ServletContextHelper.class.getName();
    }

    public boolean match(WhiteboardServiceInfo<?> info) {
        if (this.getServiceReference() != null) {
            return info.getContextSelectionFilter().match(this.getServiceReference());
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("osgi.http.whiteboard.context.name", this.getName());
        props.put("osgi.http.whiteboard.context.path", this.getPath());
        if ("org.osgi.service.http".equals(this.getName())) {
            props.put("osgi.http.whiteboard.context.httpservice", this.getName());
        }
        return info.getContextSelectionFilter().matches(props);
    }

    @Override
    public boolean isSame(AbstractInfo<ServletContextHelper> other) {
        if (!super.isSame(other)) {
            return false;
        }
        ServletContextHelperInfo o = (ServletContextHelperInfo)other;
        return Objects.equals(this.name, o.name) && Objects.equals(this.path, o.path) && Objects.equals(this.initParams, o.initParams);
    }
}

