/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.comments;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.MarkdownCommentMetaModel;
import com.github.javaparser.utils.LineSeparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MarkdownComment
extends JavadocComment {
    private static Pattern markdownLinePattern = Pattern.compile("^\\s*///(.*)$");

    public MarkdownComment() {
        this(null, "empty");
    }

    @AllFieldsConstructor
    public MarkdownComment(String content) {
        this(null, content);
    }

    public MarkdownComment(TokenRange tokenRange, String content) {
        super(tokenRange, content);
        this.customInitialization();
    }

    public String getMarkdownContent() {
        int i;
        String content = this.getContent();
        ArrayList<String> commentLines = new ArrayList<String>();
        commentLines.addAll(Arrays.asList(content.split("(\r\n|\r|\n)")));
        ArrayList<String> formattedLines = new ArrayList<String>();
        for (String string : commentLines) {
            Matcher matcher = markdownLinePattern.matcher(string);
            if (matcher.matches()) {
                formattedLines.add(matcher.group(1));
                continue;
            }
            formattedLines.add(string);
        }
        int shortestWhitespacePrefix = Integer.MAX_VALUE;
        block1: for (String string : formattedLines) {
            for (i = 0; i < string.length(); ++i) {
                if (Character.isWhitespace(string.charAt(i))) continue;
                shortestWhitespacePrefix = Math.min(shortestWhitespacePrefix, i);
                continue block1;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        LineSeparator lineSeparator = LineSeparator.detect(content);
        for (i = 0; i < formattedLines.size(); ++i) {
            String line = (String)formattedLines.get(i);
            if (line.trim().isEmpty()) {
                stringBuilder.append(line);
            } else {
                stringBuilder.append(line.substring(shortestWhitespacePrefix));
            }
            if (i == formattedLines.size() - 1) continue;
            stringBuilder.append(lineSeparator.asRawString());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getHeader() {
        return "";
    }

    @Override
    public String getFooter() {
        return "";
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public String asString() {
        String content = this.getContent();
        String lineSeparator = this.getLineEndingStyle().asRawString();
        String[] lines = content.split(lineSeparator);
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(this.getHeader());
            builder.append(line);
            builder.append(lineSeparator);
        }
        return builder.toString();
    }

    @Override
    public boolean isMarkdownComment() {
        return true;
    }

    @Override
    public MarkdownComment asMarkdownComment() {
        return this;
    }

    @Override
    public Optional<MarkdownComment> toMarkdownComment() {
        return Optional.of(this);
    }

    @Override
    public void ifMarkdownComment(Consumer<MarkdownComment> action) {
        action.accept(this);
    }

    @Override
    public MarkdownComment clone() {
        return (MarkdownComment)this.accept(new CloneVisitor(), null);
    }

    @Override
    public MarkdownCommentMetaModel getMetaModel() {
        return JavaParserMetaModel.markdownCommentMetaModel;
    }
}

